/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnacontrol.PackageConstants;
import rnadesign.rnacontrol.ScriptGenerator;
import rnadesign.rnamodel.RnaConstants;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.MultiLink;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3DSet;
import tools3d.symmetry2.SymEdgeConstraint;

public class TraceGraphScriptGenerator2
implements ScriptGenerator {
    private Object3D graphRoot;
    private Object3DSet vertices;
    private LinkSet links;
    private double distMin = 6.0;
    private double distMax = 12.0;
    private int[] helixLengths;
    private int[] origHelixIndices;
    private double kt = 10.0;
    private String name;
    private int numSteps = 100000;
    private int numStepsHelix = 500000;
    private boolean randomizeMode = false;
    private double vdwWeight = 1.0;
    private String hName = "traced_";
    private int checkLen = 0;
    private double scale = 1.4;
    private List<SymEdgeConstraint> symConstraints;
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public TraceGraphScriptGenerator2(Object3D graphRoot, LinkSet links, String name, List<SymEdgeConstraint> symConstraints, Properties params) {
        int i;
        this.graphRoot = graphRoot;
        this.vertices = new SimpleObject3DSet();
        for (i = 0; i < graphRoot.size(); ++i) {
            this.vertices.add(graphRoot.getChild(i));
        }
        this.links = new SimpleLinkSet();
        this.name = name;
        System.out.println("Starting TraceGraphScriptGenerator2 with objects:");
        for (i = 0; i < this.vertices.size(); ++i) {
            System.out.println("" + (i + 1) + " : " + this.vertices.get(i).getFullName());
        }
        for (i = 0; i < links.size(); ++i) {
            if (links.get(i) instanceof MultiLink) continue;
            if (this.vertices.contains(links.get(i).getObj1()) && this.vertices.contains(links.get(i).getObj2())) {
                this.links.add(links.get(i));
                continue;
            }
            System.out.println("Could not add link: " + links.get(i));
        }
        this.symConstraints = symConstraints;
        this.parseParams(params);
        System.out.println("Starting TraceGraphScriptGenerator2 with " + this.vertices.size() + " objects and " + this.links.size() + " links.");
    }

    private void parseParams(Properties params) {
        if (params.getProperty("min") != null) {
            this.distMin = Double.parseDouble(params.getProperty("min"));
        }
        if (params.getProperty("max") != null) {
            this.distMax = Double.parseDouble(params.getProperty("max"));
        }
    }

    @Override
    public String generate() {
        StringBuffer buf = new StringBuffer();
        buf.append("loadnucleotides ${NANOTILER_HOME}/resources/nucleotidesDB.pdb" + PackageConstants.NEWLINE);
        buf.append("set distMin " + this.distMin + PackageConstants.NEWLINE);
        buf.append("set distMax " + this.distMax + PackageConstants.NEWLINE);
        buf.append("tracernagraph root=" + this.graphRoot.getFullName() + PackageConstants.NEWLINE);
        buf.append("tree strand" + PackageConstants.NEWLINE);
        this.generateHelices();
        buf.append("exportpdb " + this.name + "_initial.pdb" + PackageConstants.NEWLINE);
        buf.append("tree strand" + PackageConstants.NEWLINE);
        buf.append(this.generateVertexConstraints() + PackageConstants.NEWLINE);
        buf.append(this.generateOptConstraints() + PackageConstants.NEWLINE);
        String outputName = this.name + ".pdb";
        buf.append("exportpdb " + outputName + PackageConstants.NEWLINE);
        return buf.toString();
    }

    private boolean isLinkDescribedBySymmetryConstraint(Link link, SymEdgeConstraint symConstraint) {
        Object3D obj1 = link.getObj1();
        Object3D obj2 = link.getObj2();
        int id1 = this.vertices.indexOf(obj1);
        int id2 = this.vertices.indexOf(obj2);
        return id1 == symConstraint.currId1 && id2 == symConstraint.currId2 || id2 == symConstraint.currId1 && id1 == symConstraint.currId2;
    }

    private int findLinkSymmetryId(int n) {
        Link link = this.links.get(n);
        Object3D obj1 = link.getObj1();
        Object3D obj2 = link.getObj2();
        int id1 = this.vertices.indexOf(obj1);
        int id2 = this.vertices.indexOf(obj2);
        log.info("Trying to find symmetry operation that involves link " + n + " " + obj1.getFullName() + " " + obj2.getFullName() + " " + id1 + " " + id2);
        if (this.symConstraints != null) {
            for (int i = 0; i < this.symConstraints.size(); ++i) {
                if (this.isLinkDescribedBySymmetryConstraint(this.links.get(n), this.symConstraints.get(i))) {
                    return i;
                }
                log.info("negative result for " + this.symConstraints.get(i));
            }
        }
        return -1;
    }

    private boolean isLinkSymmetryCopyHelix(SymEdgeConstraint symConstraint, Link link) {
        int id1 = this.vertices.indexOf(link.getObj1());
        int id2 = this.vertices.indexOf(link.getObj2());
        return symConstraint.origId1 == id1 && symConstraint.origId2 == id2 || symConstraint.origId1 == id2 && symConstraint.origId2 == id1;
    }

    private int findLinkSymmetryCopyHelix(SymEdgeConstraint symConstraint) {
        for (int i = 0; i < this.links.size(); ++i) {
            if (!this.isLinkSymmetryCopyHelix(symConstraint, this.links.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int findLinkSymmetryCopyHelix(int n) {
        if (this.symConstraints != null) {
            for (int i = 0; i < this.symConstraints.size(); ++i) {
                if (!this.isLinkDescribedBySymmetryConstraint(this.links.get(n), this.symConstraints.get(i))) continue;
                return this.findLinkSymmetryCopyHelix(this.symConstraints.get(i));
            }
        }
        return -1;
    }

    private String generateHelices() {
        this.helixLengths = new int[this.links.size()];
        this.origHelixIndices = new int[this.links.size()];
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.links.size(); ++i) {
            if (this.findLinkSymmetryCopyHelix(i) >= 0) {
                log.info("Skipping helix generation for link " + (i + 1) + " because it is a symmetry copy.");
                this.origHelixIndices[i] = this.findLinkSymmetryCopyHelix(i);
                this.helixLengths[i] = -1;
                continue;
            }
            this.origHelixIndices[i] = 0;
            double dist = this.links.get(i).getObj1().distance(this.links.get(i).getObj2());
            int numBp = (int)(dist / RnaConstants.HELIX_RISE) + 1;
            String helixName = this.hName + (i + 1);
            buf.append("genhelix bp=" + numBp + " root=root." + this.name + " name=" + helixName + PackageConstants.NEWLINE);
            Vector3D pos1 = this.links.get(i).getObj1().getPosition();
            Vector3D pos2 = this.links.get(i).getObj2().getPosition();
            Vector3D pos = Vector3D.average(pos1, pos2);
            pos1.scale(this.scale);
            pos2.scale(this.scale);
            buf.append("synth simple clonedpoints root 0 0 0" + PackageConstants.NEWLINE);
            buf.append("synth simple p1 root.clonedpoints " + pos1.getX() + " " + pos1.getY() + " " + pos1.getZ() + PackageConstants.NEWLINE);
            buf.append("synth simple p2 root.clonedpoints " + pos2.getX() + " " + pos2.getY() + " " + pos2.getZ() + PackageConstants.NEWLINE);
            String helixRoot = "root." + this.name + "." + helixName + "_root";
            buf.append("gendistconstraint " + helixRoot + "." + helixName + "_forw.1.P root.clonedpoints.p1 0 0" + PackageConstants.NEWLINE);
            buf.append("gendistconstraint " + helixRoot + "." + helixName + "_back.1.P root.clonedpoints.p2 0 0" + PackageConstants.NEWLINE);
            buf.append("optconstraints kt=100 steps=" + this.numStepsHelix + " firstfixed=true blocks=root.clonedpoints;" + helixRoot + PackageConstants.NEWLINE);
            buf.append("remove root.clonedpoints" + PackageConstants.NEWLINE);
            if (this.randomizeMode) {
                buf.append("randomize root." + this.name + "." + helixName + "_root" + PackageConstants.NEWLINE);
            }
            this.helixLengths[i] = numBp;
        }
        return buf.toString();
    }

    private boolean isSymmetryMode() {
        return this.symConstraints != null && this.symConstraints.size() > 0;
    }

    private String generateConstraints() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.helixLengths.length; ++i) {
            assert (this.helixLengths[i] != 0);
            if (this.helixLengths[i] <= 0) continue;
            int id1 = i;
            int id2 = i + 1;
            if (id2 == this.helixLengths.length) {
                id2 = 0;
            }
            String helixName1 = this.hName + id1;
            String helixName2 = this.hName + id2;
            String obj1Name = "root." + this.name + "." + helixName1 + "_root." + helixName1 + "_forw." + this.helixLengths[id1] + ".O3*";
            String obj2Name = "root." + this.name + "." + helixName2 + "_root." + helixName2 + "_forw.1.P";
            String obj1bName = "root." + this.name + "." + helixName1 + "_root." + helixName1 + "_back.1.P";
            String obj2bName = "root." + this.name + "." + helixName2 + "_root." + helixName2 + "_back." + this.helixLengths[id2] + ".O3*";
            buf.append("gendistconstraint " + obj1Name + " " + obj2Name + " ${distMin} ${distMax}" + PackageConstants.NEWLINE);
            buf.append("gendistconstraint " + obj1bName + " " + obj2bName + " ${distMin} ${distMax}" + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    private List<Integer> findVertexLinkIds(int vertexId) {
        Object3D obj = this.vertices.get(vertexId);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.links.size(); ++i) {
            assert (!(this.links.get(i) instanceof MultiLink));
            if (this.links.get(i).linkOrder(obj) <= 0) continue;
            result.add(i);
        }
        return result;
    }

    private String generateVertexConstraints() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.vertices.size(); ++i) {
            buf.append(this.generateVertexConstraint(i) + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    private String toInfoString() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append(" vertices: ");
        for (i = 0; i < this.vertices.size(); ++i) {
            result.append(this.vertices.get(i).getFullName());
            result.append(" ");
        }
        result.append(" edges: ");
        for (i = 0; i < this.links.size(); ++i) {
            result.append(((Object)this.links.get(i)).toString() + " ");
        }
        result.append(" helix lengths: ");
        if (this.helixLengths == null) {
            result.append("undefined. ");
        } else {
            for (int i2 : this.helixLengths) {
                result.append(" " + i2);
            }
        }
        result.append(" orig helix indices: ");
        if (this.origHelixIndices == null) {
            result.append("undefined. ");
        } else {
            for (int i2 : this.origHelixIndices) {
                result.append(" " + i2);
            }
        }
        if (this.symConstraints != null) {
            result.append(" Symmetry constraints: ");
            for (SymEdgeConstraint constraint : this.symConstraints) {
                result.append(" " + constraint.toString());
            }
        } else {
            result.append("No symmetry constraints defined.");
        }
        return result.toString();
    }

    private String generateVertexConstraint(int n) {
        log.info("Generating junction constraint for vertex " + n + " : " + this.vertices.get(n));
        StringBuffer buf = new StringBuffer();
        List<Integer> linkIds = this.findVertexLinkIds(n);
        System.out.println("Link ids for this vertex: ");
        for (Integer nt : linkIds) {
            System.out.print(" " + nt);
        }
        ArrayList<Integer> symIds = new ArrayList<Integer>();
        String endsText = "";
        int objCount = 0;
        System.out.println("Starting generateVertexConstraint ( " + n + " status:");
        System.out.println(this.toInfoString());
        for (int j = 0; j < linkIds.size(); ++j) {
            int id;
            int origId = id = linkIds.get(j).intValue();
            log.info("Working on link " + id + " : " + this.links.get(id).getObj1().getFullName() + " , " + this.links.get(id).getObj2().getFullName());
            if (this.isSymmetryMode()) {
                int symId = this.findLinkSymmetryId(id);
                if (symId >= 0) {
                    symIds.add(this.symConstraints.get((int)symId).symId);
                    log.info("Changing helix id from " + id + " to " + this.origHelixIndices[id] + " using symmetry descriptor " + symId + " " + this.symConstraints.get(symId).toString());
                    origId = id;
                    id = this.origHelixIndices[id];
                } else {
                    log.info("This helix " + id + " is not a symmetry copy!");
                    symIds.add(0);
                }
            } else {
                symIds.add(0);
            }
            Link link = this.links.get(origId);
            boolean proper = false;
            if (link.getObj1() != this.vertices.get(n)) {
                assert (link.getObj2() == this.vertices.get(n));
                proper = true;
            } else assert (link.getObj2() != this.vertices.get(n));
            String helixName1 = this.hName + (id + 1);
            String obj1Name = "";
            String obj2Name = "";
            String name2 = "traced";
            if (proper) {
                obj1Name = "root." + name2 + "." + helixName1 + "_root." + helixName1 + "_forw.LAST";
                obj2Name = "root." + name2 + "." + helixName1 + "_root." + helixName1 + "_back.1";
            } else {
                obj1Name = "root." + name2 + "." + helixName1 + "_root." + helixName1 + "_back.LAST";
                obj2Name = "root." + name2 + "." + helixName1 + "_root." + helixName1 + "_forw.1";
            }
            endsText = endsText.length() == 0 ? obj1Name + "," + obj2Name : endsText + "," + obj1Name + "," + obj2Name;
            objCount += 2;
        }
        StringBuffer symText = new StringBuffer();
        if (this.isSymmetryMode()) {
            symText.append("sym=");
            for (int i = 0; i < symIds.size(); ++i) {
                if (i > 0) {
                    symText.append(",");
                }
                symText.append("" + symIds.get(i));
            }
        }
        if (endsText.length() > 0 && objCount > 2) {
            buf.append("genjunctionconstraint ends=" + endsText + " min=${distMin} max=${distMax} " + symText.toString() + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    private String generateOptConstraints() {
        StringBuffer buf = new StringBuffer();
        buf.append("optconstraints steps=" + this.numSteps + " kt=" + this.kt + " vdw=" + this.vdwWeight + " blocks=");
        int appCount = 0;
        String name2 = "traced";
        for (int i = 0; i < this.helixLengths.length; ++i) {
            if (this.helixLengths[i] <= 0) continue;
            String helixName = "root." + name2 + "." + this.hName + (i + 1) + "_root";
            if (appCount > 0) {
                buf.append(";");
            }
            buf.append(helixName);
            ++appCount;
        }
        return buf.toString();
    }
}

