/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.Residue3D;
import sequence.Alphabet;
import sequence.DnaTools;
import tools3d.objects3d.SimpleObject3D;

public abstract class AbstractBiopolymer
extends SimpleObject3D
implements BioPolymer {
    protected static Alphabet alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;

    protected String getSequenceName() {
        return this.getName() + ".s";
    }

    @Override
    public String sequenceString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            result.append("" + this.getResidue(i).getSymbol().getCharacter());
        }
        return result.toString();
    }

    protected BioPolymer split(int position, BioPolymer newStrand) {
        int i;
        assert (newStrand.size() == 0);
        assert (position < this.getResidueCount());
        int oldLength = this.getResidueCount();
        String oldSequence = this.sequenceString();
        for (i = position; i < this.getResidueCount(); ++i) {
            newStrand.addResidue(this.getResidue(i));
        }
        for (i = this.getResidueCount() - 1; i >= position; --i) {
            assert (this.getChild(i) instanceof Residue3D);
            this.removeChild(i);
        }
        System.out.println("Original length: " + oldLength + " number of residues after split: " + this.getResidueCount() + " " + newStrand.getResidueCount());
        assert (this.getResidueCount() + newStrand.getResidueCount() == oldLength);
        assert (oldSequence.equals(this.sequenceString() + newStrand.sequenceString()));
        return newStrand;
    }
}

