/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import chemistrytools.DefaultChemicalElement;
import generaltools.StringTools;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.InteractionLinkImp;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.Residue3D;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteraction;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleLinkSet;

public abstract class AbstractPdbReader
implements Object3DFactory {
    protected static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final char BAD_RESIDUE_CHAR = 'X';
    public static final double COLLISION_DISTANCE = 0.7;
    public static final int EXPECT_NONSTANDARD_NUCLEOTIDES = 1;
    public static final int EXPECT_STANDARD_NUCLEOTIDES = 2;
    public static final int PRECISION = 3;
    public static final int NO_TRANSLATION = 0;
    public static final int AMBER_TO_STANDARD = 1;
    public static char defaultStrandName = (char)65;
    public static char defaultAltStrandName = (char)97;
    public static char defaultAlt2StrandName = (char)33;
    public static char defaultAlt3StrandName = (char)128;
    protected int translationMode = 1;
    protected int readMode = 2;

    protected void addStrandBackboneLinks(NucleotideStrand obj, LinkSet links) {
        for (int i = 1; i < obj.size(); ++i) {
            if (obj.getChild(i - 1) instanceof Nucleotide3D && obj.getChild(i) instanceof Nucleotide3D) {
                RnaInteractionType interactionType = new RnaInteractionType(6);
                SimpleInteraction interaction = new SimpleInteraction((Nucleotide3D)obj.getChild(i - 1), (Nucleotide3D)obj.getChild(i), interactionType);
                InteractionLinkImp link = new InteractionLinkImp(obj.getChild(i - 1), obj.getChild(i), interaction);
                links.add(link);
                continue;
            }
            log.finest("child nodes " + i + " and " + (i + 1) + " are not of type Nucleotide3D!");
        }
    }

    protected void addBackboneLinks(Object3D obj, LinkSet links) {
        if (obj instanceof NucleotideStrand) {
            this.addStrandBackboneLinks((NucleotideStrand)obj, links);
        }
        if (obj instanceof Residue3D || obj instanceof Atom3D) {
            return;
        }
        for (int i = 0; i < obj.size(); ++i) {
            this.addBackboneLinks(obj.getChild(i), links);
        }
    }

    protected void addCovalentAtomLinks(NucleotideStrand obj, LinkSet links) {
        for (int k = 0; k < obj.getResidueCount(); ++k) {
            Nucleotide3D nuc1 = (Nucleotide3D)obj.getResidue3D(k);
            if (k > 0) {
                Nucleotide3D nuc2 = (Nucleotide3D)obj.getResidue3D(k - 1);
                NucleotideTools.addCovalentAtomLinksFast(nuc1, nuc2, links);
                continue;
            }
            NucleotideTools.addCovalentAtomLinksFast(nuc1, links);
        }
    }

    protected void addCovalentLinks(Object3D obj, LinkSet links) {
        if (obj instanceof NucleotideStrand) {
            this.addCovalentAtomLinks((NucleotideStrand)obj, links);
        }
        if (obj instanceof Residue3D || obj instanceof Atom3D) {
            return;
        }
        for (int i = 0; i < obj.size(); ++i) {
            this.addCovalentLinks(obj.getChild(i), links);
        }
    }

    public static int countPdbAtoms(String[] lines) {
        int count = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf("ATOM") != 0) continue;
            ++count;
        }
        return count;
    }

    public static int countPdbAtoms(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        String[] allLines = StringTools.readAllLines(fis);
        return AbstractPdbReader.countPdbAtoms(allLines);
    }

    protected static String getKeyword(String line) {
        if (line != null) {
            if (line.length() > 6) {
                return line.substring(0, 6).trim();
            }
            return line.trim();
        }
        return null;
    }

    public int getReadMode() {
        return this.readMode;
    }

    protected boolean isTer(String line) {
        String line2 = line.trim();
        return line2.equals("TER");
    }

    protected boolean isEndMdl(String line) {
        String line2 = line.trim();
        return line2.equals("ENDMDL");
    }

    protected boolean isRemark(String line) {
        return "REMARK".equals(AbstractPdbReader.getKeyword(line));
    }

    protected static boolean isAtom(String line) {
        if (line.length() < 50) {
            return false;
        }
        String keyword = AbstractPdbReader.getKeyword(line);
        return keyword.equals("ATOM");
    }

    protected char getStrandName(String line) {
        return line.charAt(21);
    }

    protected String getResidueName(String line) {
        String result = line.substring(17, 20).trim();
        switch (this.translationMode) {
            case 0: {
                break;
            }
            case 1: {
                result = this.translateAmberToStandardResidueName(result);
            }
        }
        return result;
    }

    protected String translateAmberToStandardAtomName(String s) {
        return s.replace('\'', '*');
    }

    protected String translateAmberToStandardResidueName(String s) {
        char lastChar = s.charAt(s.length() - 1);
        if (s.length() > 1 && (lastChar == '3' || lastChar == '5')) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() > 1 && s.charAt(0) == 'R') {
            return s.substring(1, 2);
        }
        return s;
    }

    protected String getAtomElementName(String line) {
        String result = line.substring(13, 14).trim();
        return result;
    }

    protected String getAtomName(String line) {
        String result = line.substring(12, 16).trim();
        switch (this.translationMode) {
            case 0: {
                break;
            }
            case 1: {
                result = this.translateAmberToStandardAtomName(result);
            }
        }
        return result;
    }

    protected char getVersionChar(String line) {
        return line.charAt(16);
    }

    protected int getResidueId(String line) {
        String word = line.substring(22, 26).trim();
        return Integer.parseInt(word);
    }

    protected char getResidueVersionChar(String line) {
        if (line.length() <= 26) {
            return ' ';
        }
        return line.charAt(26);
    }

    protected int getAtomCounter(String line) {
        return Integer.parseInt(line.substring(7, 11).trim());
    }

    protected static double getX(String line) {
        return Double.parseDouble(line.substring(30, 38).trim());
    }

    protected static double getY(String line) {
        return Double.parseDouble(line.substring(38, 46).trim());
    }

    protected static double getZ(String line) {
        int startPos = 46;
        int endPos = startPos + 5 + 3;
        if (endPos > line.length()) {
            log.severe("Bad ATOM record encountered: " + PackageConstants.NEWLINE + line);
            assert (false);
        }
        return Double.parseDouble(line.substring(startPos, endPos).trim());
    }

    protected Atom3D generateAtomFromPdb(String line) {
        Vector3D pos = new Vector3D(AbstractPdbReader.getX(line), AbstractPdbReader.getY(line), AbstractPdbReader.getZ(line));
        String name = this.getAtomName(line);
        Atom3D atom = new Atom3D();
        atom.setPosition(pos);
        atom.setName(name);
        DefaultChemicalElement element = new DefaultChemicalElement(this.getAtomElementName(line));
        atom.setElement(element);
        return atom;
    }

    public static Vector3D[] readPdbVectors(String[] lines) {
        int numAtoms = AbstractPdbReader.countPdbAtoms(lines);
        Vector3D[] result = new Vector3D[numAtoms];
        int pc = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (!AbstractPdbReader.isAtom(lines[i])) continue;
            result[pc++] = new Vector3D(AbstractPdbReader.getX(lines[i]), AbstractPdbReader.getY(lines[i]), AbstractPdbReader.getZ(lines[i]));
        }
        return result;
    }

    protected char getStandardResidueCharacter(String residueName) {
        assert (residueName.length() > 0);
        int badChar = 88;
        int length = residueName.length();
        int result = badChar;
        if (Character.isDigit(residueName.charAt(residueName.length() - 1))) {
            return residueName.charAt(0);
        }
        switch (length) {
            case 1: {
                result = residueName.charAt(0);
                break;
            }
            case 2: {
                if (residueName.charAt(0) != '+' && residueName.charAt(0) != 'R') break;
                result = residueName.charAt(1);
                break;
            }
            case 3: {
                if (residueName.substring(1, 3).equals("3'")) {
                    result = residueName.charAt(0);
                }
                if (residueName.substring(1, 3).equals("5'")) {
                    result = residueName.charAt(0);
                }
                if (residueName.equals("ADE")) {
                    result = 65;
                    break;
                }
                if (residueName.equals("CYT")) {
                    result = 67;
                    break;
                }
                if (residueName.equals("GUA")) {
                    result = 71;
                    break;
                }
                if (residueName.equals("THY")) {
                    result = 84;
                    break;
                }
                if (!residueName.equals("URA")) break;
                result = 85;
                break;
            }
            default: {
                return residueName.charAt(0);
            }
        }
        return (char)result;
    }

    protected char getResidueCharacter(String residueName) {
        char c;
        int badChar = 88;
        int length = residueName.length();
        char result = this.getStandardResidueCharacter(residueName);
        if (result == 'X' && this.readMode == 1 && ((c = residueName.charAt(residueName.length() - 1)) == 'A' || c == 'C' || c == 'G' || c == 'U' || c == 'T')) {
            result = c;
        }
        if (result == 'B') {
            log.severe("Bad residue character B generated from " + residueName);
        }
        return result;
    }

    protected boolean isLegalResidueName(String residueName) {
        return this.getResidueCharacter(residueName) != 'X';
    }

    public int getTranslationMode() {
        return this.translationMode;
    }

    protected static double findMinimumDistance(Object3D obj, Object3DSet objSet) {
        assert (objSet.size() > 0);
        Vector3D pos = obj.getPosition();
        double dBest = pos.distance(objSet.get(0).getPosition());
        for (int i = 1; i < objSet.size(); ++i) {
            double d = pos.distance(objSet.get(i).getPosition());
            if (!(d < dBest)) continue;
            dBest = d;
        }
        return dBest;
    }

    protected char getDefaultStrandName(int strandCounter) {
        char strandName = defaultStrandName;
        if (strandCounter >= 82) {
            strandName = defaultAlt3StrandName;
            strandCounter -= 82;
        } else if (strandCounter >= 52) {
            strandName = defaultAlt2StrandName;
            strandCounter -= 52;
        } else if (strandCounter >= 26) {
            strandName = defaultAltStrandName;
            strandCounter -= 26;
        }
        return (char)(strandName + strandCounter);
    }

    char incChar(char c) {
        return (char)(c + '\u0001');
    }

    char incStrandChar(char c) {
        if (c == ' ') {
            return 'A';
        }
        if (c >= 'A' && c < 'Z') {
            return this.incChar(c);
        }
        if (c == 'Z') {
            return '0';
        }
        if (c >= '0' && c < '9') {
            return this.incChar(c);
        }
        log.warning("Too many strands, starting over at strand name A");
        return 'A';
    }

    char incStrandCharAToZ(char c) {
        if (c >= 'A' && c < 'Z') {
            return this.incChar(c);
        }
        return 'A';
    }

    protected String getHigherOrderStrandName(String strandName) {
        int num;
        String base;
        block13: {
            assert (strandName != null && strandName.length() > 0);
            if (strandName.length() == 1 && !strandName.equals("9")) {
                return "" + this.incStrandChar(strandName.charAt(0));
            }
            if (strandName.equals("9")) {
                return "A2";
            }
            if (Character.isLetter(strandName.charAt(strandName.length() - 1))) {
                return strandName + "2";
            }
            int numberIndex = StringTools.indexOfDigit(strandName);
            assert (numberIndex < strandName.length());
            base = strandName.substring(0, numberIndex);
            String rest = strandName.substring(numberIndex, strandName.length());
            if (base.length() == 1) {
                char c = base.charAt(0);
                if (c >= 'A' && c <= 'Z') {
                    if (c < 'Z') {
                        c = this.incStrandCharAToZ(c);
                        return "" + c + rest;
                    }
                    base = "A";
                } else {
                    log.severe("Unexpected strand character: " + c);
                    assert (false);
                }
            }
            num = 0;
            try {
                num = Integer.parseInt(rest);
            }
            catch (NumberFormatException nfe) {
                log.warning("Could not parse strandname: " + strandName);
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        if (base.length() == 0 && num == 9) {
            return "A2";
        }
        return base + (num + 1);
    }

    public static Vector3D readVector3D(DataInputStream dis) throws Object3DIOException {
        String word = AbstractPdbReader.readWord(dis);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Vector3D " + word);
        }
        word = AbstractPdbReader.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Vector3D " + word);
        }
        word = AbstractPdbReader.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Vector3D " + word);
        }
        return new Vector3D(x, y, z);
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
        }
        return s;
    }

    public void setReadMode(int mode) {
        this.readMode = mode;
    }

    public void setTranslationMode(int mode) {
        this.translationMode = mode;
    }

    public LinkSet getLinkSet() {
        assert (false);
        return new SimpleLinkSet();
    }
}

