/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ConstrainableDouble;
import generaltools.ConstraintDouble;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.modeling.ForceField;

public class ConstraintForceField
implements ForceField {
    private double scale = 1.0;

    public ConstraintForceField(double scale) {
        this.scale = scale;
    }

    private double constraintDist(ConstraintDouble constraint, double x) {
        if (x < constraint.getMin()) {
            return constraint.getMin() - x;
        }
        if (x > constraint.getMax()) {
            return x - constraint.getMax();
        }
        return 0.0;
    }

    @Override
    public double energy(Object3DSet objects, LinkSet links) {
        double result = 0.0;
        for (int i = 0; i < links.size(); ++i) {
            Link link = links.get(i);
            if (!(link instanceof ConstrainableDouble)) continue;
            ConstraintDouble constraint = ((ConstrainableDouble)((Object)link)).getConstraint();
            double dist = link.getObj1().distance(link.getObj2());
            double diff = this.constraintDist(constraint, dist);
            result += this.scale * constraint.getForceConstant() * diff * diff;
        }
        return result;
    }
}

