/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.BridgeFinder;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.AxisAngle;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class DoubleHelixBridgeFinder
implements BridgeFinder {
    private List<StrandJunction3D> junctions;
    private Object3D nucleotideDB;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private double angleWeight = 10.0;
    private double rms = 2.0;
    private int solutionMax = 10;
    private int lenMax = 5;
    private int lenMin = 1;
    private int len1Max = this.lenMax;
    private int len2Max = this.lenMax;
    private int len3Max = this.lenMax;
    private int verboseLevel = 2;
    private boolean avgMode = false;
    private boolean inversionMode = true;
    private char c1 = (char)71;
    private char c2 = (char)67;
    private int prop = 1;

    public DoubleHelixBridgeFinder() {
    }

    public DoubleHelixBridgeFinder(List<StrandJunction3D> junctions, Object3D nucleotideDB) {
        this.junctions = junctions;
        this.nucleotideDB = nucleotideDB;
    }

    @Override
    public List<Object3DLinkSetBundle> findBridge(Object3D obj1, Object3D obj2) {
        this.log.info("Called HelixBridgeFinder : " + obj1.getFullName() + " " + obj2.getFullName() + " rms: " + this.rms + " verbose: " + this.verboseLevel);
        if (!(obj1 instanceof BranchDescriptor3D) || !(obj2 instanceof BranchDescriptor3D)) {
            this.log.warning("Expected BranchDescriptor3D data type: " + obj1.getFullName() + " " + obj2.getFullName());
            return null;
        }
        return this.findHelixBridge((BranchDescriptor3D)obj1, (BranchDescriptor3D)obj2);
    }

    public List<Object3DLinkSetBundle> findHelixBridge(BranchDescriptor3D bd1, BranchDescriptor3D bd2) {
        double distOrig = bd1.distance(bd2);
        this.log.info("Trying to bridge distance " + distOrig);
        if (this.inversionMode) {
            double angle = bd1.getDirection().angle(bd2.getDirection());
            BranchDescriptorTools.invertBranchDescriptor(bd1, this.prop);
            BranchDescriptorTools.invertBranchDescriptor(bd2, this.prop);
            this.log.info("Inverted searching for junction with connector helices and angle: " + bd1.getFullName() + " " + bd2.getFullName() + " Angle: " + Math.toDegrees(angle) + " distance: " + distOrig);
            double distNew = bd1.distance(bd2);
            assert (distOrig != distNew);
            assert (Math.abs(distOrig - distNew) < 7.0);
        }
        double angle2 = bd1.getDirection().angle(bd2.getDirection());
        this.log.info("Searching for junction with helices and angle and distance:" + bd1.getFullName() + " " + bd2.getFullName() + " Angle: " + Math.toDegrees(angle2) + " dist: " + bd1.distance(bd2));
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        if (!this.isValid()) {
            this.log.warning("No junctions defined in helix bridge finder!");
        } else {
            Matrix4D md = this.convertBranchDescriptorPairToMatrix(bd1, bd2);
            Matrix4D m1 = bd1.getCoordinateSystem().generateMatrix4D();
            Matrix4D m2 = bd2.getCoordinateSystem().generateMatrix4D();
            List<HelixJunctionSolution> solutions = this.findHelixBridge(md);
            if (!this.inversionMode) {
                BranchDescriptorTools.invertBranchDescriptor(bd1, this.prop);
                BranchDescriptorTools.invertBranchDescriptor(bd2, this.prop);
            }
            for (int i = 0; i < solutions.size() && i < this.solutionMax; ++i) {
                result.add(solutions.get(i).convertTo3D(m1, m2));
            }
            if (!this.inversionMode) {
                BranchDescriptorTools.invertBranchDescriptor(bd1, this.prop);
                BranchDescriptorTools.invertBranchDescriptor(bd2, this.prop);
            }
        }
        if (this.inversionMode) {
            BranchDescriptorTools.invertBranchDescriptor(bd1, this.prop);
            BranchDescriptorTools.invertBranchDescriptor(bd2, this.prop);
        }
        return result;
    }

    private Matrix4D convertBranchDescriptorPairToMatrix(BranchDescriptor3D bd1, BranchDescriptor3D bd2) {
        Matrix4D m1 = bd1.getCoordinateSystem().generateMatrix4D();
        Matrix4D m2 = bd2.getCoordinateSystem().generateMatrix4D();
        return this.convertBranchDescriptorPairToMatrix(m1, m2);
    }

    private Matrix4D convertBranchDescriptorPairToMatrix(Matrix4D m1, Matrix4D m2) {
        return m1.inverse().multiply(m2);
    }

    private List<HelixJunctionSolution> findHelixBridge(Matrix4D matrix) {
        assert (this.junctions != null);
        this.log.info("Called findHelixBridge: " + matrix);
        ArrayList<HelixJunctionSolution> result = new ArrayList<HelixJunctionSolution>();
        for (int i = 0; i < this.junctions.size(); ++i) {
            block1: for (int j = i; j < this.junctions.size(); ++j) {
                List<HelixJunctionSolution> junctionSol = this.findJunctionSolutions(matrix, i, j);
                for (HelixJunctionSolution sol : junctionSol) {
                    if (!(sol.score <= this.rms)) continue;
                    result.add(sol);
                    continue block1;
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    private List<HelixJunctionSolution> findJunctionSolutions(Matrix4D matrix, int junctionId1, int junctionId2) {
        ArrayList<HelixJunctionSolution> solutions = new ArrayList<HelixJunctionSolution>();
        StrandJunction3D junction1 = this.junctions.get(junctionId1);
        StrandJunction3D junction2 = this.junctions.get(junctionId2);
        for (int hid11 = 0; hid11 < junction1.getBranchCount(); ++hid11) {
            for (int hid12 = 0; hid12 < junction1.getBranchCount(); ++hid12) {
                if (hid12 == hid11) continue;
                for (int hid21 = 0; hid21 < junction2.getBranchCount(); ++hid21) {
                    for (int hid22 = 0; hid22 < junction2.getBranchCount(); ++hid22) {
                        if (hid21 == hid22) continue;
                        solutions.addAll(this.findJunctionSolution(matrix, junctionId1, junctionId2, hid11, hid12, hid21, hid22));
                    }
                }
            }
        }
        Collections.sort(solutions);
        return solutions;
    }

    private List<HelixJunctionSolution> findJunctionSolution(Matrix4D matrix, int junctionId1, int junctionId2, int hid11, int hid12, int hid21, int hid22) {
        ArrayList<HelixJunctionSolution> solutions = new ArrayList<HelixJunctionSolution>();
        double bestScore = 1.0E30;
        for (int len1 = 0; len1 < this.len1Max; ++len1) {
            for (int len2 = 0; len2 < this.len2Max; ++len2) {
                for (int len3 = 0; len3 < this.len3Max; ++len3) {
                    double score = this.scoreJunctionSolution(matrix, junctionId1, junctionId2, hid11, hid12, hid21, hid22, len1, len2, len3);
                    if (this.verboseLevel > 3) {
                        this.log.info("Testing bridge: id; " + junctionId1 + " " + junctionId2 + " h " + hid11 + " " + hid12 + " " + hid21 + " " + hid22 + " l: " + len1 + " " + len2 + " " + len3 + " score: " + score);
                    }
                    if (!(score < this.rms)) continue;
                    if (this.verboseLevel > 2 || score < bestScore) {
                        this.log.info("Feasible bridge found: ids: " + junctionId1 + " " + junctionId2 + " h " + hid11 + " " + hid12 + " " + hid21 + " " + hid22 + " l: " + len1 + " " + len2 + " " + len3 + " score: " + score);
                    }
                    if (score < bestScore) {
                        bestScore = score;
                    }
                    HelixJunctionSolution sol = new HelixJunctionSolution();
                    sol.score = score;
                    sol.junctionId1 = junctionId1;
                    sol.junctionId2 = junctionId2;
                    sol.helixLen1 = len1;
                    sol.helixLen2 = len2;
                    sol.helixLen3 = len3;
                    sol.helixId11 = hid11;
                    sol.helixId12 = hid12;
                    sol.helixId21 = hid21;
                    sol.helixId22 = hid22;
                    solutions.add(sol);
                }
            }
        }
        return solutions;
    }

    @Override
    public int getLenMin() {
        return 1;
    }

    @Override
    public int getLenMax() {
        return 1000;
    }

    @Override
    public double getRms() {
        return this.rms;
    }

    public boolean isValid() {
        return this.junctions != null && this.junctions.size() > 0;
    }

    private double scoreJunctionSolution(Matrix4D matrix, int junctionId1, int junctionId2, int hid11, int hid12, int hid21, int hid22, int len1, int len2, int len3) {
        assert (hid11 != hid12);
        assert (hid21 != hid22);
        BranchDescriptor3D bd11 = this.junctions.get(junctionId1).getBranch(hid11);
        BranchDescriptor3D bd12 = this.junctions.get(junctionId1).getBranch(hid12);
        BranchDescriptor3D bd21 = this.junctions.get(junctionId2).getBranch(hid21);
        BranchDescriptor3D bd22 = this.junctions.get(junctionId2).getBranch(hid22);
        Matrix4D jMatrix = this.convertBranchDescriptorPairToMatrix(bd11.generatePropagatedCoordinateSystem(len1).generateMatrix4D(), bd12.generatePropagatedCoordinateSystem(len2).generateMatrix4D());
        Matrix4D m2 = BranchDescriptorTools.computeBranchDescriptorInvertedTransformation(bd21.getCoordinateSystem().generateMatrix4D(), this.prop);
        Matrix4D jMatrix2 = this.convertBranchDescriptorPairToMatrix(m2, bd22.generatePropagatedCoordinateSystem(len3).generateMatrix4D());
        Matrix4D finalMatrix = jMatrix.multiply(jMatrix2);
        double result = this.scoreMatrixDifference(matrix, finalMatrix);
        return result;
    }

    private double scoreMatrixDifference(Matrix4D m1, Matrix4D m2) {
        return AxisAngle.distanceQuatNorm(m1, m2, this.angleWeight);
    }

    public void setBasepairCharacters(char c1, char c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    @Override
    public void setAngleWeight(double weight) {
        this.angleWeight = weight;
    }

    public void setInversionMode(boolean m) {
        this.inversionMode = m;
    }

    @Override
    public void setLenMax(int n) {
        this.lenMax = n;
        this.len1Max = n;
        this.len2Max = n;
        this.len3Max = n;
    }

    @Override
    public void setLenMin(int n) {
        this.lenMin = n;
    }

    public void setJunctions(List<StrandJunction3D> junctions) {
        this.junctions = junctions;
    }

    @Override
    public void setRms(double rms) {
        this.rms = rms;
    }

    @Override
    public void setSolutionMax(int n) {
        this.solutionMax = n;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    private class HelixJunctionSolution
    implements Comparable<HelixJunctionSolution> {
        double score;
        int junctionId1;
        int junctionId2;
        int helixId11;
        int helixId12;
        int helixId21;
        int helixId22;
        int helixLen1;
        int helixLen2;
        int helixLen3;

        private HelixJunctionSolution() {
        }

        @Override
        public int compareTo(HelixJunctionSolution sol2) {
            if (this.score < sol2.score) {
                return -1;
            }
            if (this.score > sol2.score) {
                return 1;
            }
            return 0;
        }

        public Object3DLinkSetBundle convertTo3D(Matrix4D orient1, Matrix4D orient2) {
            StrandJunction3D junction1 = (StrandJunction3D)((StrandJunction3D)DoubleHelixBridgeFinder.this.junctions.get(this.junctionId1)).cloneDeep();
            StrandJunction3D junction2 = (StrandJunction3D)((StrandJunction3D)DoubleHelixBridgeFinder.this.junctions.get(this.junctionId2)).cloneDeep();
            assert (this.helixId11 >= 0 && this.helixId11 < junction1.getBranchCount());
            assert (this.helixId12 >= 0 && this.helixId12 < junction1.getBranchCount());
            assert (this.helixId21 >= 0 && this.helixId21 < junction2.getBranchCount());
            assert (this.helixId22 >= 0 && this.helixId22 < junction2.getBranchCount());
            Matrix4D m1 = junction1.getBranch(this.helixId11).generatePropagatedCoordinateSystem(this.helixLen1).generateMatrix4D();
            Matrix4D conv1 = orient1.multiply(m1.inverse());
            junction1.activeTransform(new CoordinateSystem3D(conv1));
            BranchDescriptorTools.invertBranchDescriptor(junction2.getBranch(this.helixId21), DoubleHelixBridgeFinder.this.prop);
            Matrix4D m2 = junction2.getBranch(this.helixId21).getCoordinateSystem().generateMatrix4D();
            Matrix4D orientH = junction1.getBranch(this.helixId12).generatePropagatedCoordinateSystem(this.helixLen2).generateMatrix4D();
            BranchDescriptorTools.invertBranchDescriptor(junction2.getBranch(this.helixId21), DoubleHelixBridgeFinder.this.prop);
            Matrix4D conv2 = orientH.multiply(m2.inverse());
            junction2.activeTransform(new CoordinateSystem3D(conv2));
            SimpleObject3D root = new SimpleObject3D();
            root.setPosition(Vector3D.average(junction1.getPosition(), junction2.getPosition()));
            root.setName("bridge");
            root.setProperty("score", "" + this.score);
            root.setProperty("junction1_id", "" + (this.junctionId1 + 1));
            root.setProperty("junction2_id", "" + (this.junctionId2 + 1));
            root.setProperty("helix_id_1_1", "" + (this.helixId11 + 1));
            root.setProperty("helix_id_1_2", "" + (this.helixId12 + 1));
            root.setProperty("helix_id_2_1", "" + (this.helixId21 + 1));
            root.setProperty("helix_id_2_2", "" + (this.helixId22 + 1));
            root.setProperty("helix_len_1", "" + this.helixLen1);
            root.setProperty("helix_len_2", "" + this.helixLen2);
            root.setProperty("helix_len_3", "" + this.helixLen3);
            root.insertChildSafe(junction1);
            root.insertChildSafe(junction2);
            if (DoubleHelixBridgeFinder.this.nucleotideDB != null) {
                if (this.helixLen1 > 0) {
                    String stem1Name = "stem1";
                    junction1.getBranch(this.helixId11).propagate(1);
                    Object3DLinkSetBundle stem1Bundle = ConnectJunctionTools.generateIdealStem(junction1.getBranch(this.helixId11), DoubleHelixBridgeFinder.this.c1, DoubleHelixBridgeFinder.this.c2, stem1Name, DoubleHelixBridgeFinder.this.nucleotideDB, this.helixLen1);
                    junction1.getBranch(this.helixId11).propagate(-1);
                    if (stem1Bundle.getObject3D() != null) {
                        DoubleHelixBridgeFinder.this.log.info("Generated bridge stem 1: " + stem1Bundle.getObject3D().getFullName());
                        junction1.insertChildSafe(stem1Bundle.getObject3D());
                    } else {
                        DoubleHelixBridgeFinder.this.log.info("No helix (1) could be generated for " + junction1.getBranch(this.helixId11).getFullName() + " and length " + this.helixLen2);
                    }
                }
                if (this.helixLen2 > 0) {
                    String stem2Name = "stem2";
                    junction1.getBranch(this.helixId12).propagate(1);
                    Object3DLinkSetBundle stem2Bundle = ConnectJunctionTools.generateIdealStem(junction1.getBranch(this.helixId12), DoubleHelixBridgeFinder.this.c1, DoubleHelixBridgeFinder.this.c2, stem2Name, DoubleHelixBridgeFinder.this.nucleotideDB, this.helixLen2);
                    junction1.getBranch(this.helixId12).propagate(-1);
                    if (stem2Bundle.getObject3D() != null) {
                        DoubleHelixBridgeFinder.this.log.info("Generated bridge stem 2: " + stem2Bundle.getObject3D().getFullName());
                        junction1.insertChildSafe(stem2Bundle.getObject3D());
                    } else {
                        DoubleHelixBridgeFinder.this.log.info("No helix (2) could be generated for " + junction1.getBranch(this.helixId12).getFullName() + " and length " + this.helixLen2);
                    }
                }
                if (this.helixLen3 > 0) {
                    String stem3Name = "stem3";
                    BranchDescriptor3D bd = junction2.getBranch(this.helixId22);
                    assert (bd != null);
                    bd.propagate(1);
                    Object3DLinkSetBundle stem3Bundle = ConnectJunctionTools.generateIdealStem(bd, DoubleHelixBridgeFinder.this.c1, DoubleHelixBridgeFinder.this.c2, stem3Name, DoubleHelixBridgeFinder.this.nucleotideDB, this.helixLen3);
                    bd.propagate(-1);
                    if (stem3Bundle.getObject3D() != null) {
                        DoubleHelixBridgeFinder.this.log.info("Generated bridge stem 3: " + stem3Bundle.getObject3D().getFullName());
                        junction2.insertChildSafe(stem3Bundle.getObject3D());
                    } else {
                        DoubleHelixBridgeFinder.this.log.info("No helix (3) could be generated for " + bd.getFullName() + " and length " + this.helixLen3);
                    }
                }
            } else {
                DoubleHelixBridgeFinder.this.log.warning("Could not generate bridging helices because no reference nucleotides are defined!");
            }
            return new SimpleObject3DLinkSetBundle(root, new SimpleLinkSet());
        }
    }
}

