/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.DoubleFunctor;

public class GaussianFunctor
implements DoubleFunctor {
    private double scale;
    private double offs;
    private double sigma;
    private double sigmaSquare;

    public GaussianFunctor(double sigma, double offs, double scale) {
        this.sigma = sigma;
        this.sigmaSquare = sigma * sigma;
        this.offs = offs;
        this.scale = scale;
    }

    @Override
    public double doubleFunc(double value) {
        return this.scale * Math.exp(-(value -= this.offs) * value / this.sigmaSquare);
    }

    public double getSigma() {
        return this.sigma;
    }
}

