/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.SimpleConstraintDouble;
import graphtools.IntegerArrayGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import numerictools.IntegerArrayTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import tools3d.Vector3D;
import tools3d.Vector3DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DException;
import tools3d.objects3d.Object3DFactory2;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class GraphJunctionFactory
implements Object3DFactory2 {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private Object3D nucleotideDB;
    private List<Object3DLinkSetBundle> helices;
    private List<BranchDescriptor3D> bds;
    private char c1 = (char)71;
    private char c2 = (char)67;
    private int logInterval = 10000;
    private int numBasePairs = 10;
    private double offset = 20.0;
    private double distMin = 5.0;
    private double distMax = 8.0;
    private double limitScore = 0.0;
    private Vector3D corner;
    private Vector3D[] neighbors;
    private double[] angles;
    private int angleDiv = 120;
    private double angleStep = Math.PI * 2 / (double)this.angleDiv;
    private String rootName = "j";
    private SimpleConstraintDouble constraint;

    public GraphJunctionFactory(Vector3D corner, Vector3D[] neighbors, Object3D nucleotideDB) {
        assert (corner != null);
        assert (neighbors != null);
        assert (nucleotideDB != null);
        this.corner = corner;
        this.neighbors = neighbors;
        this.nucleotideDB = nucleotideDB;
        this.angles = new double[neighbors.length];
        for (int i = 0; i < this.angles.length; ++i) {
            this.angles[i] = 0.0;
        }
        this.initConstraint();
    }

    private void initConstraint() {
        this.constraint = new SimpleConstraintDouble(this.distMin, this.distMax);
        this.constraint.setSquareMode(false);
    }

    @Override
    public Object3DLinkSetBundle generate() throws Object3DException {
        int i;
        assert (this.corner != null && this.neighbors != null);
        log.info("Starting to generate Junction from corner position " + this.corner);
        if (this.neighbors.length < 2) {
            throw new Object3DException("At least two neighbor positions must be specified, found only: " + this.neighbors.length);
        }
        this.bds = new ArrayList<BranchDescriptor3D>();
        this.helices = new ArrayList<Object3DLinkSetBundle>();
        for (i = 0; i < this.neighbors.length; ++i) {
            BranchDescriptor3D bd = this.generateBranchDescriptor(this.corner, this.neighbors[i]);
            bd.setName("bd" + (i + 1));
            this.bds.add(bd);
            log.info("Placed branch descriptor " + (i + 1) + " : " + bd.infoString());
            assert (Math.abs(bd.getPosition().distance(this.corner) - this.offset) < 0.1);
        }
        log.info("Placed " + this.bds.size() + " branch descriptors.");
        for (i = 0; i < this.neighbors.length; ++i) {
            String helixName = "h" + (i + 1);
            this.helices.add(this.generateHelix(this.bds.get(i), helixName));
        }
        log.info("Generated " + this.helices.size() + " helices.");
        Properties properties = this.optimizeHelices();
        return this.generateFinalBundle(properties);
    }

    private BranchDescriptor3D generateBranchDescriptor(Vector3D cornerPos, Vector3D neighborPos) throws Object3DException {
        Vector3D z = neighborPos.minus(cornerPos);
        if (z.lengthSquare() == 0.0) {
            throw new Object3DException("Corner coincided with neighbor position!");
        }
        z.normalize();
        Vector3D base = cornerPos.plus(z.mul(this.offset));
        assert (Math.abs(base.distance(cornerPos) - this.offset) < 0.1);
        Vector3D y = Vector3DTools.generateRandomOrthogonalDirection(z);
        Vector3D x = y.cross(z);
        CoordinateSystem3D cs = new CoordinateSystem3D(base, x, y, z);
        assert (cs.getPosition().distance(base) < 0.01);
        log.info("Using coordinate system " + cs);
        SimpleBranchDescriptor3D bd = new SimpleBranchDescriptor3D(cs);
        double dist = bd.getPosition().distance(cornerPos);
        assert (Math.abs(dist - this.offset) < 0.1);
        return bd;
    }

    private Object3DLinkSetBundle generateFinalBundle(Properties properties) {
        int i;
        SimpleObject3D root = new SimpleObject3D();
        SimpleLinkSet links = new SimpleLinkSet();
        root.setName(this.rootName);
        for (i = 0; i < this.helices.size(); ++i) {
            Object3D helix = this.helices.get(i).getObject3D();
            BranchDescriptor3D bd = this.bds.get(i);
            helix.rotate(bd.getBasePosition(), bd.getDirection(), this.angles[i]);
            root.insertChild(helix);
            links.merge(this.helices.get(i).getLinks());
        }
        for (i = 0; i < this.bds.size(); ++i) {
            BranchDescriptor3D bd = this.bds.get(i);
            bd.rotate(bd.getBasePosition(), bd.getDirection(), this.angles[i]);
            root.insertChild(bd);
        }
        root.setProperties(properties);
        return new SimpleObject3DLinkSetBundle(root, links);
    }

    private Object3DLinkSetBundle generateHelix(BranchDescriptor3D bd, String helixName) {
        return ConnectJunctionTools.generateIdealStem(bd, this.c1, this.c2, helixName, this.nucleotideDB, this.numBasePairs);
    }

    private Properties optimizeHelices() {
        log.info("Starting to optimize helices!");
        IntegerArrayGenerator intGen = new IntegerArrayGenerator(this.angles.length, this.angleDiv);
        int[] bestComb = intGen.get();
        double bestScore = this.computeHelixScore(bestComb, -1.0);
        int count = 0;
        while (intGen.hasNext()) {
            ++count;
            double score = this.computeHelixScore(intGen.next(), bestScore);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestComb = intGen.get();
            log.info("New best optimization score at iteration " + count + " : " + bestScore);
            if (!(score <= this.limitScore)) continue;
            log.info("Limit score reached, quitting loop!");
            break;
        }
        for (int i = 0; i < bestComb.length; ++i) {
            this.angles[i] = (double)bestComb[i] * this.angleStep;
        }
        IntegerArrayTools.writeArray(System.out, bestComb);
        log.info("Finished to optimize helices!");
        Properties properties = new Properties();
        properties.setProperty("best_score", "" + bestScore);
        return properties;
    }

    private double computeHelixScore(int[] angleCombination, double cutoff) {
        assert (angleCombination != null && angleCombination.length == this.angles.length);
        double score = 0.0;
        for (int i = 1; i < this.angles.length; ++i) {
            score += this.computeHelixScore(angleCombination, cutoff, i - 1, i);
        }
        return score += this.computeHelixScore(angleCombination, cutoff, this.angles.length - 1, 0);
    }

    private double computeHelixScore(int[] angleCombination, double cutoff, int id1, int id2) {
        assert (id1 != id2);
        double score = 0.0;
        Vector3D p1 = this.computeConnectingPosition1(angleCombination, id1);
        Vector3D p2 = this.computeConnectingPosition2(angleCombination, id2);
        double dist = p1.distance(p2);
        score = this.constraint.getDiff(dist);
        return score;
    }

    private Vector3D computeConnectingRawPosition1(int id) {
        Object3D root = this.helices.get(id).getObject3D();
        int idx = root.getIndexOfChild(1, "RnaStrand");
        assert (idx >= 0);
        RnaStrand strand = (RnaStrand)root.getChild(idx);
        Residue3D residue = strand.getResidue3D(strand.getResidueCount() - 1);
        Object3D atom = residue.getChild("O3*");
        double dist = atom.distance(this.bds.get(id));
        if (dist > 15.0) {
            log.warning("Strange distance: " + this.bds.get(id).infoString() + " and " + atom);
        }
        assert (dist < 15.0);
        return atom.getPosition();
    }

    private Vector3D computeConnectingRawPosition2(int id) {
        Object3D root = this.helices.get(id).getObject3D();
        int idx = root.getIndexOfChild(0, "RnaStrand");
        assert (idx >= 0);
        RnaStrand strand = (RnaStrand)root.getChild(idx);
        Residue3D residue = strand.getResidue3D(0);
        Object3D atom = residue.getChild("P");
        assert (atom.distance(this.bds.get(id)) < 11.0);
        return atom.getPosition();
    }

    private Vector3D computeConnectingPosition1(int[] angleCombination, int id) {
        Vector3D p = this.computeConnectingRawPosition1(id);
        double angle = this.angleStep * (double)angleCombination[id];
        BranchDescriptor3D bd = this.bds.get(id);
        double dOrig = bd.getBasePosition().distance(p);
        p.rotate(bd.getBasePosition(), bd.getDirection(), angle);
        double dNew = bd.getBasePosition().distance(p);
        assert (Math.abs(dOrig - dNew) < 0.01);
        return p;
    }

    private Vector3D computeConnectingPosition2(int[] angleCombination, int id) {
        Vector3D p = this.computeConnectingRawPosition2(id);
        double angle = this.angleStep * (double)angleCombination[id];
        p.rotate(this.bds.get(id).getBasePosition(), this.bds.get(id).getDirection(), angle);
        return p;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setAngleDiv(int n) {
        this.angleDiv = n;
    }

    public void setDistMax(double distMax) {
        this.distMax = distMax;
        this.initConstraint();
    }

    public void setDistMin(double distMin) {
        this.distMin = distMin;
        this.initConstraint();
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }
}

