/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.StrandJunctionDB;
import tools3d.CoordinateSystem;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.SimpleMultiLink;

public class JunctionDBConstraintLink
extends SimpleMultiLink {
    private List<Integer> symIds = new ArrayList<Integer>();
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    List<BranchDescriptor3D> branches;
    StrandJunctionDB junctionDB;
    boolean scoreAllMode = true;
    public static final double NO_MATCH_SCORE = 100.0;

    public JunctionDBConstraintLink(List<BranchDescriptor3D> _branches, StrandJunctionDB _junctionDB) {
        assert (_branches != null);
        this.junctionDB = _junctionDB;
        for (int i = 0; i < _branches.size(); ++i) {
            this.addObj(_branches.get(i));
            this.symIds.add(0);
        }
        log.info("Added junctionDBConstraint link of size " + this.size());
        assert (this.junctionDB != null);
    }

    @Override
    public void addObj(Object3D obj) {
        assert (obj instanceof BranchDescriptor3D);
        super.addObj(obj);
    }

    public double computeScore() {
        List<BranchDescriptor3D> branches = this.getBranches();
        double bestScore = 100.0;
        if (this.scoreAllMode) {
            List<Double> sims = this.junctionDB.scoreAllJunctions(branches);
            for (double score : sims) {
                if (!(score < bestScore)) continue;
                bestScore = score;
            }
        } else {
            assert (false);
            Map<Integer, Double> sims = this.junctionDB.findAndScoreSimilarJunctions(branches);
            bestScore = 100.0;
            Set<Integer> keys = sims.keySet();
            Iterator<Integer> it = keys.iterator();
            while (it.hasNext()) {
                double score = sims.get(it.next());
                if (!(score < bestScore)) continue;
                bestScore = score;
            }
        }
        return bestScore;
    }

    public Properties computeScore(List<CoordinateSystem> activeTransformations) {
        List<Double> sims;
        List<BranchDescriptor3D> branches = this.getBranches();
        double bestScore = 100.0;
        int bestId = 0;
        if (this.scoreAllMode) {
            sims = this.junctionDB.scoreAllJunctions(branches, activeTransformations);
            Iterator<Double> it = sims.iterator();
            if (!it.hasNext()) {
                log.info("No junctions to score found!");
            }
            int count = 0;
            while (it.hasNext()) {
                double score = it.next();
                if (score < bestScore) {
                    bestScore = score;
                    bestId = count;
                }
                ++count;
            }
        } else {
            assert (false);
            sims = this.junctionDB.findAndScoreSimilarJunctions(branches, activeTransformations);
            bestScore = 100.0;
            Set keys = sims.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                int id = (Integer)it.next();
                double score = (Double)sims.get((Object)id);
                if (!(score < bestScore)) continue;
                bestScore = score;
                bestId = id;
            }
        }
        Properties properties = new Properties();
        properties.setProperty("score", "" + bestScore);
        String junctionIdString = "" + branches.size() + " " + bestId;
        for (int i = 0; i < branches.size(); ++i) {
            junctionIdString = junctionIdString + " " + branches.get(i).getFullName();
        }
        properties.setProperty(this.junctionDB.getName(), junctionIdString);
        return properties;
    }

    public BranchDescriptor3D getBranch(int n) {
        return (BranchDescriptor3D)this.getObj(n);
    }

    public int getBranchCount() {
        return this.size();
    }

    public List<BranchDescriptor3D> getBranches() {
        ArrayList<BranchDescriptor3D> branches = new ArrayList<BranchDescriptor3D>();
        for (int i = 0; i < this.size(); ++i) {
            branches.add(this.getBranch(i));
        }
        return branches;
    }

    public int getSymId(int index) {
        return this.symIds.get(index);
    }

    public void setSymId(int index, int _symId1) {
        while (this.symIds.size() <= index) {
            this.symIds.add(-1);
        }
        this.symIds.set(index, _symId1);
    }

    public void setSymId1(int _symId1) {
        this.setSymId(0, _symId1);
    }

    public void setSymId2(int _symId2) {
        this.setSymId(1, _symId2);
    }

    public String toPrettyString() {
        return this.toString();
    }

    @Override
    public String toString() {
        int i;
        String result = "(JunctionDBConstraintLink " + this.getName();
        for (i = 0; i < this.size(); ++i) {
            result = result + " " + this.getObj(i).getFullName();
        }
        for (i = 0; i < this.symIds.size(); ++i) {
            result = result + " " + this.symIds.get(i);
        }
        result = result + " )";
        return result;
    }

    public boolean validate() {
        return this.getBranchCount() > 0 && this.symIds.size() == this.getBranchCount();
    }
}

