/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.StrandJunction3D;

public class JunctionQualityChecker {
    public boolean isContinuous(StrandJunction3D junction) {
        for (int i = 0; i < junction.getStrandCount(); ++i) {
            if (this.isContinuousStrand(junction.getStrand(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isContinuousStrand(NucleotideStrand strand) {
        int size = strand.getResidueCount();
        if (size < 2) {
            return true;
        }
        Residue3D firstResidue = strand.getResidue3D(0);
        Residue3D lastResidue = strand.getResidue3D(size - 1);
        assert (firstResidue instanceof Nucleotide3D);
        assert (lastResidue instanceof Nucleotide3D);
        int size2 = ((Nucleotide3D)lastResidue).getAssignedNumber() - ((Nucleotide3D)firstResidue).getAssignedNumber() + 1;
        return size2 == size;
    }
}

