/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class PointSetReader
implements Object3DFactory {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static CoordinateSystem3D debugCs;
    public static Object3D debugPoint;
    private int formatMode = 1;

    @Override
    public Object3DLinkSetBundle readBundle(InputStream is) throws Object3DIOException {
        Object3D obj = this.readAnyObject3D(is);
        LinkSet links = this.readLinks(is, obj);
        this.readAndAddTransformations(is, obj, links);
        log.info("Read " + obj.size() + " objects and " + links.size() + " links.");
        return new SimpleObject3DLinkSetBundle(obj, links);
    }

    @Override
    public Object3D readAnyObject3D(InputStream is) throws Object3DIOException {
        log.fine("Starting readAnyObject3D!");
        DataInputStream dis = new DataInputStream(is);
        SimpleObject3D root = new SimpleObject3D();
        root.setName("PointSetImport");
        String word = PointSetReader.readWord(dis);
        int numEntries = Integer.parseInt(word);
        log.fine("reading " + numEntries + " entries.");
        for (int i = 0; i < numEntries; ++i) {
            PointSetReader.readWord(dis);
            Vector3D pos = PointSetReader.readVector3D(dis);
            log.fine("coordinates of point " + (i + 1) + " : " + pos);
            SimpleObject3D child = new SimpleObject3D();
            child.setPosition(pos);
            child.setName("p" + i);
            root.insertChild(child);
        }
        return root;
    }

    public LinkSet readLinks(InputStream is, Object3D root) throws Object3DIOException {
        log.fine("Starting readAnyObject3D!");
        DataInputStream dis = new DataInputStream(is);
        SimpleLinkSet links = new SimpleLinkSet();
        root.setName("ImportedLinks");
        String word = PointSetReader.readWord(dis);
        int numEntries = Integer.parseInt(word);
        for (int i = 0; i < numEntries; ++i) {
            boolean silentMode = false;
            String word1 = PointSetReader.readWord(dis);
            String word2 = PointSetReader.readWord(dis);
            int id1 = Integer.parseInt(word1);
            int id2 = Integer.parseInt(word2);
            if (id1 < 0) {
                silentMode = true;
                id1 *= -1;
            }
            log.fine("Creating links between objects : " + id1 + " " + id2);
            if (--id1 >= root.size() || --id2 >= root.size()) {
                throw new Object3DIOException("Error reading point set: Point index larger than number of defined points!");
            }
            SimpleLink link = new SimpleLink(root.getChild(id1), root.getChild(id2));
            if (silentMode) {
                link.setProperty("silent", "true");
            }
            links.add(link);
        }
        return links;
    }

    public void readAndAddTransformation(InputStream is, Object3D points, LinkSet links) throws Object3DIOException {
        try {
            DataInputStream dis = new DataInputStream(is);
            int numVals = 9;
            double[] vals = new double[numVals];
            String name = PointSetReader.readWord(dis);
            for (int i = 0; i < numVals; ++i) {
                vals[i] = Double.parseDouble(PointSetReader.readWord(dis));
            }
            Vector3D basePos = new Vector3D(vals[0], vals[1], vals[2]);
            Vector3D x = new Vector3D(vals[3], vals[4], vals[5]);
            Vector3D y = new Vector3D(vals[6], vals[7], vals[8]);
            int numObjects = Integer.parseInt(PointSetReader.readWord(dis));
            CoordinateSystem3D cs = new CoordinateSystem3D(basePos, x, y);
            debugCs = (CoordinateSystem3D)cs.cloneDeep();
            log.fine("Read coordinate system: " + cs.toString());
            log.fine("Stored debug coordinate system: " + debugCs.toString());
            cs.setName(name);
            for (int i = 0; i < numObjects; ++i) {
                int objectId = Integer.parseInt(PointSetReader.readWord(dis)) - 1;
                points.getChild(objectId).insertChild((Object3D)cs.cloneDeep());
                debugPoint = points.getChild(objectId);
            }
            int numLinks = Integer.parseInt(PointSetReader.readWord(dis));
            for (int i = 0; i < numLinks; ++i) {
                int linkId = Integer.parseInt(PointSetReader.readWord(dis)) - 1;
                links.get(linkId).setProperty("symmetry:" + name, "1");
            }
        }
        catch (NumberFormatException nfe) {
            throw new Object3DIOException("Number format exception while reading points format file: " + nfe.getMessage());
        }
    }

    public void readAndAddTransformations(InputStream is, Object3D points, LinkSet links) throws Object3DIOException {
        log.fine("Starting readAnyObject3D!");
        DataInputStream dis = new DataInputStream(is);
        String word = "";
        word = PointSetReader.readWord(dis);
        if (word.length() == 0) {
            log.fine("No symmetry transformations defined. Must be old-style points file.");
            return;
        }
        int numEntries = Integer.parseInt(word);
        for (int i = 0; i < numEntries; ++i) {
            this.readAndAddTransformation(is, points, links);
        }
    }

    public static Vector3D readVector3D(DataInputStream dis) throws Object3DIOException {
        log.fine("starting readVector!");
        String word = PointSetReader.readWord(dis);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            x = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse x coordinate for Vector3D " + word);
        }
        word = PointSetReader.readWord(dis);
        try {
            y = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse y coordinate for Vector3D " + word);
        }
        word = PointSetReader.readWord(dis);
        try {
            z = Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("Could not parse z coordinate for Vector3D " + word);
        }
        log.fine("ending readVector!");
        return new Vector3D(x, y, z);
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            log.finest("found word: " + s);
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        log.finest("found word: " + s);
        return s;
    }
}

