/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ConstraintDouble;
import generaltools.SimpleConstraintDouble;
import rnadesign.rnamodel.ProteinStrand;
import sequence.UnknownSymbolException;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleObject3DSet;

public class Protein3DTools {
    public static final double RAD2DEG = 57.29577951308232;
    public static final double DEG2RAD = Math.PI / 180;
    public static final double HELIX_RISE = 3.4;
    public static final double RESIDUE_DIST = 3.5;
    public static final double WATSON_CRICK_DIST_MIN = 3.0;
    public static final double WATSON_CRICK_DIST = 4.0;
    public static final double WATSON_CRICK_DIST_MAX = 5.0;
    public static final ConstraintDouble RNA_WC_CONSTRAINT = new SimpleConstraintDouble(3.0, 5.0);
    public static final ConstraintDouble RNA_CHAIN_CONSTRAINT = new SimpleConstraintDouble(3.0, 5.0);

    public static Object3DSet collectProteinStrands(Object3D root) {
        SimpleObject3DSet stemSet = new SimpleObject3DSet();
        for (int i = 0; i < root.size(); ++i) {
            Object3D child = root.getChild(i);
            if (!(child instanceof ProteinStrand)) continue;
            stemSet.add(child);
        }
        return stemSet;
    }

    public static Object3DLinkSetBundle generateSimpleProteinStrand(String name, String seqString, Vector3D pos, Vector3D dir) throws UnknownSymbolException {
        assert (false);
        return null;
    }

    public static String oneLetterToThreeLetter(char c) {
        switch (c) {
            case 'A': {
                return "ALA";
            }
            case 'C': {
                return "CYS";
            }
            case 'D': {
                return "ASP";
            }
            case 'E': {
                return "GLU";
            }
            case 'F': {
                return "PHE";
            }
            case 'G': {
                return "GLY";
            }
            case 'H': {
                return "HIS";
            }
            case 'I': {
                return "ILE";
            }
            case 'K': {
                return "LYS";
            }
            case 'L': {
                return "LEU";
            }
            case 'M': {
                return "MET";
            }
            case 'N': {
                return "ASN";
            }
            case 'P': {
                return "PRO";
            }
            case 'Q': {
                return "GLN";
            }
            case 'R': {
                return "ARG";
            }
            case 'S': {
                return "SER";
            }
            case 'T': {
                return "THR";
            }
            case 'V': {
                return "VAL";
            }
            case 'W': {
                return "TRP";
            }
            case 'Y': {
                return "TYR";
            }
        }
        return "UNK";
    }
}

