/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.ResultWorker;
import generaltools.ScoreWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnamodel.AI3DTools;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.HelixConstraintLink;
import rnadesign.rnamodel.HelixOptimizer;
import rnadesign.rnamodel.LinkGenerator;
import rnadesign.rnamodel.PackageConstants;
import rnadesign.rnamodel.SimpleHelixConstraintLink;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleLinkSet;

public class RingFixLinkGenerator
extends ResultWorker
implements LinkGenerator {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double constraintRms = 10.0;
    private List<StrandJunction3D> junctions;
    private List<List<StrandJunction3D>> junctionClasses;
    private int helixLengthMax = 30;

    public RingFixLinkGenerator(List<StrandJunction3D> junctions) {
        this.junctions = junctions;
        assert (this.junctions != null);
    }

    public RingFixLinkGenerator(Object3DSet junctionSet) {
        this.junctions = new ArrayList<StrandJunction3D>();
        for (int i = 0; i < junctionSet.size(); ++i) {
            Object3D obj = junctionSet.get(i);
            if (!(obj instanceof StrandJunction3D)) continue;
            this.junctions.add((StrandJunction3D)obj);
        }
    }

    @Override
    public LinkSet getLinks() {
        return (LinkSet)this.getResult();
    }

    @Override
    protected void runInternal() {
        System.out.println("Starting RingFixLinkGenerator.runInternal!");
        assert (this.junctions != null);
        this.junctionClasses = AI3DTools.classifyJunctions(this.junctions);
        this.result = this.findHelixConstraints();
        assert (this.getLinks() != null);
        System.out.println("Finished RingFixLinkGenerator.runInternal!");
    }

    private ScoreWrapper generateRawConstraint(BranchDescriptor3D b1, BranchDescriptor3D b2, double rms) {
        log.info("Starting generateRawConstraint(1) with " + b1.getFullName() + " " + b2.getFullName());
        int helixLength = ConnectJunctionTools.computeBestStemLength(b1, b2);
        if (helixLength > this.helixLengthMax) {
            return null;
        }
        log.info("continuing generateRawConstraint(1) with " + b1.getFullName() + " " + b2.getFullName());
        return this.generateRawConstraint(b1, b2, rms, helixLength);
    }

    private ScoreWrapper generateRawConstraint(BranchDescriptor3D b1, BranchDescriptor3D b2, double rms, int helixLength) {
        log.info("Starting generateRawConstraint(2) with " + b1.getFullName() + " " + b2.getFullName());
        if (b1.getParent() == b2.getParent()) {
            log.info("Internal error: branch descriptors have same parent node: " + b1.getFullName() + " " + b1.getParent().getFullName() + PackageConstants.NEWLINE + b2.getFullName() + " " + b2.getParent().getFullName());
        }
        assert (b1.getParent() != b2.getParent());
        SimpleHelixConstraintLink constraint = new SimpleHelixConstraintLink(b1, b2, helixLength, helixLength, rms);
        double score = HelixOptimizer.computeBranchDescriptorError(b1, b2, CoordinateSystem3D.CARTESIAN, CoordinateSystem3D.CARTESIAN, helixLength);
        ScoreWrapper wrap = new ScoreWrapper(constraint, score);
        return wrap;
    }

    private List<ScoreWrapper> generateRawConstraints(StrandJunction3D junction1, StrandJunction3D junction2) {
        assert (junction1 != junction2);
        ArrayList<ScoreWrapper> rawConstraints = new ArrayList<ScoreWrapper>();
        for (int i = 0; i < junction1.getBranchCount(); ++i) {
            for (int j = 0; j < junction2.getBranchCount(); ++j) {
                assert (junction1.getBranch(i) != junction2.getBranch(j));
                assert (junction1 != junction2);
                if (junction1.getBranch(i).getParent() == junction2.getBranch(j).getParent()) {
                    log.info("Internal error: branch descriptors have same parent node: " + junction1.getFullName() + " " + junction1.getBranch(i).getFullName() + " " + junction1.getBranch(i).getParent().getFullName() + PackageConstants.NEWLINE + junction2.getFullName() + " " + junction2.getBranch(j).getFullName() + " " + junction1.getBranch(j).getParent().getFullName());
                    assert (junction1.getBranch(i).getParent() == junction2.getBranch(j).getParent());
                } else if (junction1.getBranch(i).getParent() != junction2.getBranch(j).getParent()) {
                    log.info("Everything ok using " + junction1.getFullName() + " " + junction2.getFullName());
                }
                assert (junction1.isValid());
                assert (junction2.isValid());
                assert (junction1.getBranch(i).getParent() != junction2.getBranch(j).getParent());
                assert (junction1.getBranch(i).getParent() == junction1);
                assert (junction2.getBranch(j).getParent() == junction2);
                assert (junction1 != junction2);
                log.info("Starting generateRawConstraint with " + junction1.getBranch(i).getFullName() + " " + junction2.getBranch(j).getFullName());
                ScoreWrapper wrap = this.generateRawConstraint(junction1.getBranch(i), junction2.getBranch(j), this.constraintRms);
                if (wrap == null) continue;
                rawConstraints.add(wrap);
            }
        }
        return rawConstraints;
    }

    private List<HelixConstraintLink> generateSortedRawConstraints(List<StrandJunction3D> junctions) {
        ArrayList<ScoreWrapper> tmpResult = new ArrayList<ScoreWrapper>();
        for (int i = 0; i < junctions.size(); ++i) {
            for (int j = i + 1; j < junctions.size(); ++j) {
                List<ScoreWrapper> tmpResult2 = this.generateRawConstraints(junctions.get(i), junctions.get(j));
                if (tmpResult2.size() <= 0) continue;
                Collections.sort(tmpResult2);
                tmpResult.add(tmpResult2.get(0));
            }
        }
        Collections.sort(tmpResult);
        ArrayList<HelixConstraintLink> result = new ArrayList<HelixConstraintLink>();
        for (ScoreWrapper obj : tmpResult) {
            HelixConstraintLink constraint = (HelixConstraintLink)obj.getObject();
            result.add(constraint);
        }
        return result;
    }

    private LinkSet findHelixConstraints() {
        assert (this.junctionClasses != null);
        SimpleLinkSet helixConstraints = new SimpleLinkSet();
        List<HelixConstraintLink> rawConstraints = this.generateSortedRawConstraints(this.junctions);
        for (HelixConstraintLink link : rawConstraints) {
            assert (link instanceof HelixConstraintLink);
            HelixConstraintLink constraintLink = link;
            if (!this.constraintAvailable(constraintLink)) continue;
            this.placeEquivalentConstraints(constraintLink, helixConstraints, rawConstraints);
        }
        return helixConstraints;
    }

    private boolean constraintAvailable(HelixConstraintLink constraint) {
        BranchDescriptor3D b1 = (BranchDescriptor3D)constraint.getObj1();
        BranchDescriptor3D b2 = (BranchDescriptor3D)constraint.getObj2();
        return b1.getProperty("__RINGFIX_HELIXSTATUS") == null && b2.getProperty("__RINGFIX_HELIXSTATUS") == null;
    }

    private void placeConstraint(HelixConstraintLink constraint, LinkSet helixConstraints) {
        if (this.constraintAvailable(constraint)) {
            constraint.getObj1().setProperty("__RINGFIX_HELIXSTATUS", "occupied");
            constraint.getObj2().setProperty("__RINGFIX_HELIXSTATUS", "occupied");
            helixConstraints.add(constraint);
        }
    }

    private List<HelixConstraintLink> generateSortedEquivalentConstraints(HelixConstraintLink constraint) {
        assert (constraint.getBasePairMin() == constraint.getBasePairMax());
        BranchDescriptor3D b1 = (BranchDescriptor3D)constraint.getObj1();
        BranchDescriptor3D b2 = (BranchDescriptor3D)constraint.getObj2();
        StrandJunction3D j1 = (StrandJunction3D)b1.getParent();
        StrandJunction3D j2 = (StrandJunction3D)b2.getParent();
        int id1 = j1.getIndexOfChild(b1);
        int id2 = j2.getIndexOfChild(b2);
        int class1 = Integer.parseInt(j1.getProperty("__JUNCTION_CLASS"));
        int class2 = Integer.parseInt(j2.getProperty("__JUNCTION_CLASS"));
        assert (b1.getProperty("__RINGFIX_HELIXSTATUS") == null && b2.getProperty("__RINGFIX_HELIXSTATUS") == null);
        ArrayList<ScoreWrapper> rawConstraints = new ArrayList<ScoreWrapper>();
        for (int i = 0; i < this.junctionClasses.get(class1).size(); ++i) {
            StrandJunction3D junction1 = this.junctionClasses.get(class1).get(i);
            for (int j = 0; j < this.junctionClasses.get(class2).size(); ++j) {
                StrandJunction3D junction2 = this.junctionClasses.get(class2).get(j);
                if (junction1 == junction2) continue;
                assert (junction1 != junction2);
                assert (junction1.getChild(id1) != junction2.getChild(id2));
                rawConstraints.add(this.generateRawConstraint((BranchDescriptor3D)junction1.getChild(id1), (BranchDescriptor3D)junction2.getChild(id2), this.constraintRms, constraint.getBasePairMin()));
            }
        }
        Collections.sort(rawConstraints);
        ArrayList<HelixConstraintLink> result = new ArrayList<HelixConstraintLink>();
        for (ScoreWrapper wrap : rawConstraints) {
            result.add((HelixConstraintLink)wrap.getObject());
        }
        return result;
    }

    private void placeEquivalentConstraints(HelixConstraintLink constraint, LinkSet helixConstraints, List<HelixConstraintLink> rawConstraints) {
        assert (this.constraintAvailable(constraint));
        List<HelixConstraintLink> equivConstraints = this.generateSortedEquivalentConstraints(constraint);
        for (HelixConstraintLink c : equivConstraints) {
            this.placeConstraint(c, helixConstraints);
        }
    }

    private boolean checkConstraintEquivalenceInternal(HelixConstraintLink constraint1, HelixConstraintLink constraint2) {
        BranchDescriptor3D b11 = (BranchDescriptor3D)constraint1.getObj1();
        BranchDescriptor3D b12 = (BranchDescriptor3D)constraint1.getObj2();
        BranchDescriptor3D b21 = (BranchDescriptor3D)constraint2.getObj1();
        BranchDescriptor3D b22 = (BranchDescriptor3D)constraint2.getObj2();
        StrandJunction3D j11 = (StrandJunction3D)b11.getParent();
        StrandJunction3D j12 = (StrandJunction3D)b12.getParent();
        StrandJunction3D j21 = (StrandJunction3D)b21.getParent();
        StrandJunction3D j22 = (StrandJunction3D)b22.getParent();
        return j11.getProperty("__JUNCTION_CLASS").equals(j21.getProperty("__JUNCTION_CLASS")) && j12.getProperty("__JUNCTION_CLASS").equals(j22.getProperty("__JUNCTION_CLASS")) && j11.getIndexOfChild(b11) == j21.getIndexOfChild(b21) && j12.getIndexOfChild(b12) == j22.getIndexOfChild(b22);
    }

    private boolean checkConstraintEquivalence(HelixConstraintLink constraint1, HelixConstraintLink constraint2) {
        boolean result = this.checkConstraintEquivalenceInternal(constraint1, constraint2);
        if (result) {
            return true;
        }
        HelixConstraintLink swapped = (HelixConstraintLink)constraint2.clone();
        swapped.swap();
        return this.checkConstraintEquivalenceInternal(constraint1, swapped);
    }
}

