/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.List;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.SequenceCollector;
import rnadesign.rnamodel.StrandJunction3D;
import sequence.Sequence;
import tools3d.objects3d.Object3D;

public class SecondaryStructureSequenceCollector
extends SequenceCollector {
    private List<Sequence> list = new ArrayList<Sequence>();

    @Override
    public void act(Object3D obj) {
        if (obj instanceof BioPolymer && SecondaryStructureSequenceCollector.secondaryStructureSequence(obj)) {
            BioPolymer strand = (BioPolymer)obj;
            this.addSequence(strand);
        }
    }

    @Override
    public void addSequence(Sequence s) {
        this.list.add(s);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Sequence getSequence(int n) {
        if (n < this.getSequenceCount()) {
            return this.list.get(n);
        }
        return null;
    }

    @Override
    public int getSequenceCount() {
        return this.list.size();
    }

    private static boolean secondaryStructureSequence(Object3D o) {
        if (o.getParent() == null) {
            return true;
        }
        if (o.getParent() instanceof StrandJunction3D) {
            return false;
        }
        return SecondaryStructureSequenceCollector.secondaryStructureSequence(o.getParent());
    }
}

