/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.List;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.SequenceObject3D;
import sequence.Sequence;
import sequence.SequenceContainer;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DAction;

public class SequenceCollector
implements Object3DAction,
SequenceContainer {
    private List<Sequence> list = new ArrayList<Sequence>();

    @Override
    public void act(Object3D obj) {
        if (obj instanceof SequenceObject3D) {
            SequenceObject3D rna = (SequenceObject3D)obj;
            for (int i = 0; i < rna.getSequenceCount(); ++i) {
                this.addSequence(rna.getSequence(i));
            }
        } else if (obj instanceof BioPolymer) {
            BioPolymer strand = (BioPolymer)obj;
            this.addSequence(strand);
        }
    }

    @Override
    public void addSequence(Sequence s) {
        this.list.add(s);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Sequence getSequence(int n) {
        if (n < this.getSequenceCount()) {
            return this.list.get(n);
        }
        return null;
    }

    @Override
    public int getSequenceCount() {
        return this.list.size();
    }

    public int size() {
        return this.list.size();
    }
}

