/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.Properties;
import rnadesign.rnamodel.AbstractBranchDescriptorOptimizer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.RnaStem3D;

public class SimpleBranchDescriptorOptimizer
extends AbstractBranchDescriptorOptimizer {
    public static final String CLASS_NAME = "SimpleBranchDescriptorOptimizer";
    private double rmsLimit;

    public SimpleBranchDescriptorOptimizer(FitParameters limits) {
        this.rmsLimit = limits.getRmsLimit();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public BranchDescriptor3D optimize(RnaStem3D stem, BranchDescriptor3D branch1, BranchDescriptor3D branch2) throws FittingException {
        return SimpleBranchDescriptorOptimizer.optimize(stem, branch1, branch2, this.rmsLimit);
    }

    private static BranchDescriptor3D optimize(RnaStem3D stem, BranchDescriptor3D branch1, BranchDescriptor3D branch2, double rmsLimit) throws FittingException {
        assert (branch1.isValid());
        assert (branch2.isValid());
        int bestAngle = 0;
        double bestError = rmsLimit + 1.0E-4;
        for (int a = 0; a < 360; ++a) {
            try {
                BranchDescriptor3D b = SimpleBranchDescriptorOptimizer.interpolateBranchDescriptor(stem, branch1, branch2, Math.PI / 180 * (double)a);
                double errorVal = SimpleBranchDescriptorOptimizer.computeBranchDescriptorError(stem.getLength(), branch1, branch2, b);
                log.fine("Optimizing stem: " + a + " " + errorVal);
                if (errorVal > rmsLimit || !(errorVal < bestError)) continue;
                bestError = errorVal;
                bestAngle = a;
                continue;
            }
            catch (FittingException fe) {
                log.info("could not get good helix fit for angle: " + a);
            }
        }
        if (bestError > rmsLimit) {
            return null;
        }
        BranchDescriptor3D bBest = SimpleBranchDescriptorOptimizer.interpolateBranchDescriptor(stem, branch1, branch2, 57.29577951308232 * (double)bestAngle);
        Properties prop = bBest.getProperties();
        if (prop == null) {
            prop = new Properties();
            bBest.setProperties(prop);
        }
        log.fine("Optimized stem: " + bestAngle + " " + bestError);
        prop.setProperty("fit_score", "" + bestError);
        assert (bBest.getProperties() != null);
        return bBest;
    }
}

