/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import graphtools.IntegerPermutatorList;
import java.util.List;
import java.util.Properties;
import rnadesign.rnamodel.BasepairOptimizer;
import rnadesign.rnamodel.RnaModelException;
import tools3d.CoordinateSystem;
import tools3d.OrientableModifier;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3DSet;

public class SystematicBasepairOptimizer
extends BasepairOptimizer {
    private IntegerPermutatorList permutators;

    public SystematicBasepairOptimizer(LinkSet links, List<Object3DSet> objectBlocks, LinkSet basePairDB, IntegerPermutatorList permutators) {
        super(links, objectBlocks, 0, 0.0, basePairDB, null, null);
        assert (objectBlocks.size() == permutators.size());
        this.permutators = permutators;
    }

    private void mutateCoordinateSystems(List<CoordinateSystem> optCoordinateSystems) {
        for (int i = 0; i < optCoordinateSystems.size(); ++i) {
            OrientableModifier mutator = (OrientableModifier)this.permutators.get(i);
            String ts = optCoordinateSystems.get(i).toString();
            mutator.mutate(optCoordinateSystems.get(i));
        }
    }

    @Override
    public Properties optimize() {
        Properties properties = new Properties();
        if (this.optCoordinateSystems == null || this.optCoordinateSystems.size() == 0) {
            String errMsg = "No coordinate systems defined for optimization. Maybe add helix constraints?";
            log.info(errMsg);
            properties.setProperty("message", errMsg);
            return properties;
        }
        log.info("Number of relevant coordinate systems: " + this.origCoordinateSystems.size());
        String s2 = "";
        this.copyCoordinateSystems(this.optCoordinateSystems, this.origCoordinateSystems);
        List<CoordinateSystem> saveCoords = this.cloneCoordinateSystems(this.origCoordinateSystems);
        List<CoordinateSystem> bestCoords = this.cloneCoordinateSystems(this.origCoordinateSystems);
        IntegerPermutatorList bestPermutators = null;
        try {
            double newScore;
            double bestScore = newScore = this.scoreCoordinateSystems(this.optCoordinateSystems, properties);
            properties.setProperty("start_score", "" + bestScore);
            int iter = 0;
            this.assertMovables();
            this.permutators.reset();
            do {
                this.optCoordinateSystems = this.cloneCoordinateSystems(saveCoords);
                this.mutateCoordinateSystems(this.optCoordinateSystems);
                newScore = this.scoreCoordinateSystems(this.optCoordinateSystems, properties);
                if (newScore < bestScore) {
                    bestScore = newScore;
                    bestPermutators = (IntegerPermutatorList)this.permutators.clone();
                    this.copyCoordinateSystems(bestCoords, this.optCoordinateSystems);
                    log.info("New best score found: " + bestScore + " at iteration " + (iter + 1));
                    if (newScore < this.getScoreMinimumLimit()) {
                        log.info("Quitting optimization, because score is lower than minimum score cutoff: " + this.getScoreMinimumLimit());
                        break;
                    }
                }
                if (++iter % this.outputInterval != 0) continue;
                log.info("Iteration: " + iter + " Current and best score so far: " + newScore + " " + bestScore);
                log.info("Mutators: " + this.permutators.toString());
                log.info("First coordinate system: " + this.optCoordinateSystems.get(0));
                if (bestPermutators == null) continue;
                log.info("Best mutators: " + bestPermutators.toString());
            } while (this.permutators.inc());
            this.applyTransformations(bestCoords);
            properties.setProperty("number_steps", "" + (iter + 1));
            properties.setProperty("final_score", "" + bestScore);
            if (bestPermutators != null) {
                properties.setProperty("final_status", "" + bestPermutators.toString());
            }
        }
        catch (RnaModelException rme) {
            properties.setProperty("error", rme.getMessage());
        }
        log.info("Optimization finished: " + properties);
        this.assertMovables();
        return properties;
    }
}

