/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.ParsingException;
import generaltools.StringTools;
import generaltools.TestTools;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import numerictools.AccuracyTools;
import numerictools.DoubleArrayTools;
import numerictools.IntervalInt;
import org.testng.annotations.Test;
import secondarystructuredesign.PackageConstants;

public class RnaFoldTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesign");

    public static double[][] parseRnafoldProbabilities(String[] lines) throws ParsingException {
        String line;
        int pc = 0;
        boolean foundSequence = false;
        for (pc = 0; pc < lines.length; ++pc) {
            line = lines[pc];
            if (line.length() <= 9 || !line.substring(0, 9).equals("/sequence")) continue;
            foundSequence = true;
            break;
        }
        if (!foundSequence) {
            throw new ParsingException("Could not find sequence header!");
        }
        assert (++pc < lines.length);
        String sequence = lines[pc];
        while (sequence.charAt(sequence.length() - 1) == '\\') {
            if (pc + 1 >= lines.length) {
                throw new ParsingException("Error parsing sequence in RNAfold file");
            }
            sequence = sequence.substring(0, sequence.length() - 1) + lines[++pc];
        }
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (c != '\\' && c != ')') continue;
            sequence = sequence.substring(0, i);
            break;
        }
        int numRes = sequence.length();
        double[][] result = new double[numRes][numRes];
        try {
            while (++pc < lines.length) {
                line = lines[pc].trim();
                String[] words = line.split(" ");
                if (words.length != 4 || !words[3].equals("ubox")) continue;
                int id1 = Integer.parseInt(words[0]) - 1;
                int id2 = Integer.parseInt(words[1]) - 1;
                result[id1][id2] = Double.parseDouble(words[2]);
                double[] dArray = result[id1];
                int n = id2;
                dArray[n] = dArray[n] * result[id1][id2];
                result[id2][id1] = result[id1][id2];
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParsingException("Number format exception in line " + (pc + 1) + " : " + nfe.getMessage());
        }
        return result;
    }

    @Test(groups={"new"})
    public void parseRnafoldProbabilitiesTest() {
        String methodName;
        block9: {
            methodName = "parseRnafoldProbabilitiesTest";
            System.out.println(TestTools.generateMethodHeader(methodName));
            String filename = PackageConstants.NANOTILER_HOME + "/test/fixtures/yeslogic_rnafold.ps";
            try {
                FileInputStream fis = new FileInputStream(filename);
                String[] lines = StringTools.readAllLines(fis);
                double[][] matrix = RnaFoldTools.parseRnafoldProbabilities(lines);
                assert (matrix != null);
                assert (matrix.length > 0);
                assert (matrix[0] != null && matrix[0].length == matrix.length);
                System.out.println("Imported probability matrix: " + matrix.length + " x " + matrix[0].length);
                DoubleArrayTools.writeMatrix(System.out, matrix);
                assert (matrix.length == 80);
                assert (Math.abs(matrix[16][42] - 0.695) < 0.05);
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                assert (false);
            }
            catch (ParsingException pe) {
                System.out.println(pe.getMessage());
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    public static double parseRnafoldEnergy(String[] lines) throws ParsingException {
        if (lines == null || lines.length < 2) {
            throw new ParsingException("Expected at least two lines in RNAfold output!");
        }
        String lastLine = lines[lines.length - 1];
        String[] words = lastLine.split(" ");
        double result = 0.0;
        if (words.length < 2) {
            throw new ParsingException("Expected structure and energy in last line of RNAfold input: " + lastLine);
        }
        String lastWord = words[words.length - 1];
        if (lastWord.charAt(0) == '(') {
            lastWord = lastWord.substring(1, lastWord.length());
        }
        assert (lastWord.length() > 0);
        if (lastWord.charAt(lastWord.length() - 1) == ')') {
            lastWord = lastWord.substring(0, lastWord.length() - 1);
        }
        try {
            result = Double.parseDouble(lastWord);
        }
        catch (NumberFormatException nfe) {
            throw new ParsingException("Expected energy in last line of RNAfold input: " + words[words.length - 1] + " : " + nfe.getMessage());
        }
        catch (RuntimeException e) {
            throw new ParsingException("Expected energy in last line of RNAfold input: " + words[words.length - 1] + " : " + e.getMessage());
        }
        return result;
    }

    public static String parseRnafoldStructure(String[] lines) throws ParsingException {
        int id;
        if (lines == null || lines.length < 2) {
            throw new ParsingException("Expected at least two lines in RNAfold output!");
        }
        int n = id = lines[0].charAt(0) == '>' ? 2 : 1;
        if (id >= lines.length) {
            throw new ParsingException("Not sufficient number of  lines in rnafold structure!");
        }
        String lastLine = lines[id];
        String[] words = lastLine.split(" ");
        if (words.length < 2) {
            throw new ParsingException("Expected structure and energy in last line of RNAfold input: " + lastLine);
        }
        return words[0];
    }

    public static String parseRnacofoldStructure(String[] lines) throws ParsingException {
        String[] words;
        if (lines == null || lines.length < 2) {
            throw new ParsingException("Expected at least two lines in RNAcofold output!");
        }
        String line = lines[1];
        if (lines[0].charAt(0) == '>') {
            if (lines.length < 3) {
                throw new ParsingException("Expected at least three lines in RNAcofold output!");
            }
            line = lines[2];
        }
        if ((words = line.split(" ")).length < 2) {
            System.out.println("Severe error while parsing:");
            for (int i = 0; i < lines.length; ++i) {
                System.out.println(lines[i]);
            }
            throw new ParsingException("Expected structure and energy in last line of RNAcofold input: " + line);
        }
        return words[0];
    }

    public static double parseRnacofoldEnergies(String[] lines, int id) throws ParsingException {
        assert (id >= 0 && id < 5);
        if (lines == null || lines.length < 2) {
            throw new ParsingException("Expected at least two lines in RNAcofold output!");
        }
        String lastLine = lines[lines.length - 1];
        String[] words = lastLine.split(" ");
        if (words.length == 1) {
            words = lastLine.split("\t");
        }
        double result = 0.0;
        if (words.length < 5) {
            throw new ParsingException("Energy in last line of RNAcofold input: " + lastLine);
        }
        try {
            assert (id < words.length);
            result = Double.parseDouble(words[id]);
        }
        catch (RuntimeException e) {
            throw new ParsingException("Expected energy in last line of RNAcofold input: " + words[words.length - 1]);
        }
        return result;
    }

    public static double parseRnacofoldEnergyAB(String[] lines) throws ParsingException {
        return RnaFoldTools.parseRnacofoldEnergies(lines, 0);
    }

    public static double parseRnacofoldEnergyAA(String[] lines) throws ParsingException {
        return RnaFoldTools.parseRnacofoldEnergies(lines, 1);
    }

    public static double parseRnacofoldEnergyBB(String[] lines) throws ParsingException {
        return RnaFoldTools.parseRnacofoldEnergies(lines, 2);
    }

    public static double parseRnacofoldEnergyA(String[] lines) throws ParsingException {
        return RnaFoldTools.parseRnacofoldEnergies(lines, 3);
    }

    public static double parseRnacofoldEnergyB(String[] lines) throws ParsingException {
        return RnaFoldTools.parseRnacofoldEnergies(lines, 4);
    }

    @Test(groups={"new"})
    public void testParseRnacofoldEnergies() {
        block8: {
            String sampleInput = "GGGAAAAACCGUUUCGAUCUCCUACGACGGAGCUUUACGUUAUCUGACCG&GGGAAAUAUCCUACGGCACCACUAUAAUGACUAUGGAGAUCGAAUGAAUC\n((......))..((((((((((...((((........))))...((.(((&((((....)))).)))))................))))))))))...... (-27.60)\n((......))..((((((((((...((((........))))...{(.(((&((({....}))).)))),................))))))))))...... [-29.69]\nfrequency of mfe structure in ensemble 0.0761266 , delta G binding=-13.28\nFree Energies:\nAB AA BB A B\n-29.687247 -22.955548 -17.775745 -9.670848 -6.741081\n";
            String[] lines = sampleInput.split("\n");
            assert (lines.length == 7);
            try {
                assert (Math.abs(RnaFoldTools.parseRnacofoldEnergyAB(lines) - -29.68) < 0.1);
                assert (Math.abs(RnaFoldTools.parseRnacofoldEnergyAA(lines) - -22.96) < 0.1);
                assert (Math.abs(RnaFoldTools.parseRnacofoldEnergyBB(lines) - -17.78) < 0.1);
                assert (Math.abs(RnaFoldTools.parseRnacofoldEnergyA(lines) - -9.67) < 0.1);
                assert (Math.abs(RnaFoldTools.parseRnacofoldEnergyB(lines) - -6.74) < 0.1);
            }
            catch (ParsingException pe) {
                System.out.println("Error parsing RNAcofold energy output: " + pe.getMessage());
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
    }

    public static int[][] parseBracketInteractions(String structure) {
        int foundInteractions;
        assert (structure != null);
        int len = structure.length();
        int[][] result = new int[len][len];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        int numInteractions = StringTools.countChar(structure, '(');
        StringBuffer buf = new StringBuffer(structure);
        for (foundInteractions = 0; foundInteractions < numInteractions; ++foundInteractions) {
            IntervalInt intervall = RnaFoldTools.findInnerInteraction(buf.toString());
            if (intervall == null) {
                log.info("Could not find inner interactions in: " + structure);
                break;
            }
            int j = intervall.getLower();
            int k = intervall.getUpper();
            log.fine("Found interaction");
            log.fine("Structure: " + structure);
            log.fine("Interaction: " + j + "   " + k);
            result[j][k] = 1;
            result[k][j] = 1;
            buf.setCharAt(j, '.');
            buf.setCharAt(k, '.');
        }
        assert (foundInteractions == numInteractions);
        return result;
    }

    public static int[][] parseRnacofoldBracketInteractions(String structure) {
        int foundInteractions;
        assert (structure != null);
        String linker = "&";
        char linkChar = linker.charAt(0);
        int sepId = structure.indexOf(linkChar);
        if (sepId < 0) {
            System.err.println("Strange RNAcofold bracket interaction (no & character): " + structure);
            assert (false);
        }
        int len1 = sepId;
        int len2 = structure.length() - len1 - linker.length();
        int[][] result = new int[len1][len2];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        int numInteractions = StringTools.countChar(structure, '(');
        StringBuffer buf = new StringBuffer(structure);
        for (foundInteractions = 0; foundInteractions < numInteractions; ++foundInteractions) {
            IntervalInt intervall = RnaFoldTools.findInnerInteraction(buf.toString());
            if (intervall == null) {
                log.info("Could not find inner interactions in: " + structure);
                break;
            }
            int j = intervall.getLower();
            int k = intervall.getUpper() - linker.length() - len1;
            log.fine("Found interaction");
            log.fine("Structure: " + structure);
            log.fine("Interaction: " + j + "   " + k);
            if (j < sepId && k >= 0) {
                result[j][k] = 1;
            }
            buf.setCharAt(intervall.getLower(), '.');
            buf.setCharAt(intervall.getUpper(), '.');
        }
        assert (foundInteractions == numInteractions);
        return result;
    }

    public static int[][] parseRnacofoldBracketSingleInteractions(String structure, boolean firstSequence) {
        int foundInteractions;
        int sepId;
        assert (structure != null);
        String linker = "&";
        char linkChar = linker.charAt(0);
        int len1 = sepId = structure.indexOf(linkChar);
        int len2 = structure.length() - len1 - linker.length();
        int lenSide = len1;
        if (!firstSequence) {
            lenSide = len2;
        }
        int[][] result = new int[lenSide][lenSide];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        int numInteractions = StringTools.countChar(structure, '(');
        StringBuffer buf = new StringBuffer(structure);
        for (foundInteractions = 0; foundInteractions < numInteractions; ++foundInteractions) {
            IntervalInt intervall = RnaFoldTools.findInnerInteraction(buf.toString());
            if (intervall == null) {
                log.info("Could not find inner interactions in: " + structure);
                break;
            }
            int jOrig = intervall.getLower();
            int kOrig = intervall.getUpper();
            int j = jOrig;
            int k = kOrig;
            if (firstSequence) {
                if (k < sepId) {
                    result[j][k] = 1;
                }
            } else if ((j -= sepId - 1) >= 0 && (k -= sepId - 1) >= 0 && j < result.length && k < result[0].length && k < sepId) {
                result[j][k] = 1;
            }
            buf.setCharAt(jOrig, '.');
            buf.setCharAt(kOrig, '.');
        }
        assert (foundInteractions == numInteractions);
        return result;
    }

    public static double computeMatrixMatthews(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            block5: for (int j = i + 1; j < trueInteractions[0].length; ++j) {
                int pv = predictedInteractions[i][j];
                int tv = trueInteractions[i][j];
                switch (tv) {
                    case 1: {
                        if (pv == 1) {
                            ++tp;
                            continue block5;
                        }
                        ++fn;
                        continue block5;
                    }
                    case -1: {
                        if (pv == 1) {
                            ++fp;
                            continue block5;
                        }
                        ++tn;
                        continue block5;
                    }
                    default: {
                        assert (false);
                        continue block5;
                    }
                }
            }
        }
        return AccuracyTools.computeMatthews(tp, fp, tn, fn);
    }

    public static double computeMatrixDifference(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int count = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            for (int j = 0; j < trueInteractions[0].length; ++j) {
                if (trueInteractions[i][j] == predictedInteractions[i][j] || trueInteractions[i][j] == 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static double countMissedInteractions(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int count = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            for (int j = 0; j < trueInteractions[0].length; ++j) {
                if (trueInteractions[i][j] == -1 || trueInteractions[i][j] == 0 || predictedInteractions[i][j] != -1 && predictedInteractions[i][j] != 0) continue;
                ++count;
            }
        }
        return count;
    }

    private static int findInnerInteraction(String s, int n) {
        if (s.charAt(n) != '(') {
            return -1;
        }
        for (int i = n + 1; i < s.length(); ++i) {
            if (s.charAt(i) == ')') {
                return i;
            }
            if (s.charAt(i) != '(') continue;
            return -1;
        }
        return -1;
    }

    private static IntervalInt findInnerInteraction(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int j = RnaFoldTools.findInnerInteraction(s, i);
            if (j < 0) continue;
            return new IntervalInt(i, j);
        }
        return null;
    }
}

