/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import numerictools.IntegerArrayTools;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SecondaryStructure;
import secondarystructuredesign.PackageConstants;
import secondarystructuredesign.PknotsRGParser;
import secondarystructuredesign.RnaFoldTools;
import secondarystructuredesign.SecondaryStructureScorer;

public class RnacofoldSecondaryStructureScorer
implements SecondaryStructureScorer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesign");
    private static String rnafoldScriptName = rb.getString("rnafoldscript");
    private static String rnacofoldScriptName = rb.getString("rnacofoldscript");
    private static String pknotsScriptName = rb.getString("pknotsscript");
    private boolean interStrandMode = true;
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private String linkerSequence = "&";
    private String pkLinkerSequence = "";
    private boolean energyMode = true;
    private boolean pkMode = false;
    private int debugLevel = 2;
    private Level debugLogLevel = Level.FINE;
    private SecondaryStructureScorer subScorer;
    private double subScorerWeight = 1.0;
    private double selfEnergyCutoff = 0.0;
    private double structureWeight = 1.0;
    private double energyGap = 0.0;
    private boolean countMissedMode = true;
    private StringBuffer[] lastSeqs = null;
    private double[] singleSequenceScoreCache = null;
    private double[][] sequencePairScoreCache = null;
    public static final int RNAFOLD_BLOCK_SIZE = 2;
    public static final int RNACOFOLD_BLOCK_SIZE = 7;

    public double interactionEnergy(char c1, char c2) {
        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
            return 0.0;
        }
        if (c1 > c2) {
            return this.interactionEnergy(c2, c1);
        }
        switch (c1) {
            case 'A': {
                if (c2 == 'U') {
                    return this.energyAU;
                }
            }
            case 'C': {
                if (c2 != 'G') break;
                return this.energyGC;
            }
        }
        return 0.0;
    }

    String[] launchFolding(String sequence) throws IOException {
        File tmpInputFile = File.createTempFile("nanotiler_rnafold", ".seq");
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        ps.println(sequence);
        fos.close();
        File tmpOutputFile = File.createTempFile("nanotiler_rnafold", ".sec");
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        String scriptName = rnacofoldScriptName;
        if (this.pkMode) {
            scriptName = pknotsScriptName;
        } else if (sequence.indexOf(38) < 0) {
            scriptName = rnafoldScriptName;
        }
        File tempFile = new File(scriptName);
        String[] commandWords = new String[]{scriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        this.log.log(this.debugLogLevel, "Issuing command: " + scriptName + " " + inputFileName + " " + outputFileName);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        String[] resultLines = null;
        FileInputStream resultFile = null;
        try {
            resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            this.log.warning("Error when scraping result file from: " + outputFileName);
            assert (false);
            throw ioe;
        }
        finally {
            if (resultFile != null) {
                resultFile.close();
                File file = new File(outputFileName);
                file.delete();
            }
            if (tmpInputFile != null) {
                tmpInputFile.delete();
            }
        }
        if (resultLines == null) {
            this.log.warning("Rnacofold results were null!");
        }
        return resultLines;
    }

    public String getLinker() {
        if (this.pkMode) {
            return this.pkLinkerSequence;
        }
        return this.linkerSequence;
    }

    private String generateFusedSequence(String s1, String s2) {
        return s1 + this.getLinker() + s2;
    }

    private int[][] generateFusedInteractions(int[][] interactions) {
        int j;
        int i;
        int linkLen = this.getLinker().length();
        int l1 = interactions.length;
        int l2 = interactions[0].length;
        int fusedLen = l1 + linkLen + l2;
        assert (fusedLen > 0);
        int[][] result = new int[fusedLen][fusedLen];
        for (i = 0; i < result.length; ++i) {
            for (j = 0; j < result[0].length; ++j) {
                result[i][j] = -1;
            }
        }
        for (i = 0; i < interactions.length; ++i) {
            for (j = 0; j < interactions[0].length; ++j) {
                if (interactions[i][j] != 1) continue;
                int id1 = i;
                int id2 = j + l1 + linkLen;
                assert (id1 < result.length);
                assert (id2 < result[0].length);
                result[id1][id2] = 1;
                result[id2][id1] = 1;
            }
        }
        return result;
    }

    private boolean isInteracting(int[][] interactions) {
        for (int i = 0; i < interactions.length; ++i) {
            for (int j = i + 1; j < interactions[i].length; ++j) {
                if (interactions[i][j] == -1) continue;
                return true;
            }
        }
        return false;
    }

    private double scoreStructureSequencePair(StringBuffer bseq1, StringBuffer bseq2, int[][] interactions, int[][] interactions1, int[][] interactions2, String[] rnafoldLines) throws IOException, ParseException {
        assert (interactions.length == bseq1.length());
        assert (interactions[0].length == bseq2.length());
        String fusedSequence = "";
        int len1 = bseq1.length();
        int len2 = bseq2.length();
        if (rnafoldLines == null) {
            fusedSequence = this.generateFusedSequence(bseq1.toString(), bseq2.toString());
            rnafoldLines = this.launchFolding(fusedSequence);
        }
        int[][] predictedInteractions = null;
        int[][] predictedInteractions1 = null;
        int[][] predictedInteractions2 = null;
        if (this.debugLogLevel.intValue() >= Level.INFO.intValue()) {
            System.out.println("Output of folding algorithm:");
            for (int i = 0; i < rnafoldLines.length; ++i) {
                System.out.println(rnafoldLines[i]);
            }
        }
        if (this.pkMode) {
            PknotsRGParser parser = new PknotsRGParser();
            MutableSecondaryStructure structure = parser.parse(rnafoldLines);
            int[][] allInteractions = structure.toInteractionMatrix(0, 0);
            assert (allInteractions != null && allInteractions.length > 0);
            assert (allInteractions.length == allInteractions[0].length);
            predictedInteractions = IntegerArrayTools.subMatrix(allInteractions, len1 + this.getLinker().length(), 0, allInteractions.length, len1);
            assert (predictedInteractions.length == len1);
            assert (predictedInteractions[0].length == len2);
            predictedInteractions1 = IntegerArrayTools.subMatrix(allInteractions, 0, 0, len1, len1);
            predictedInteractions2 = IntegerArrayTools.subMatrix(allInteractions, len1 + this.getLinker().length(), len1 + this.getLinker().length(), allInteractions.length, allInteractions[0].length);
            if (this.debugLevel > 2) {
                System.out.println("All interactions:");
                IntegerArrayTools.writeMatrix(System.out, allInteractions);
                System.out.println("Cross interactions:");
                IntegerArrayTools.writeMatrix(System.out, predictedInteractions);
                System.out.println("Interactions internal to first sequence:");
                IntegerArrayTools.writeMatrix(System.out, predictedInteractions1);
                System.out.println("Interactions internal to second sequence:");
                IntegerArrayTools.writeMatrix(System.out, predictedInteractions2);
            }
        } else {
            String bracket = RnaFoldTools.parseRnafoldStructure(rnafoldLines);
            if (this.debugLogLevel.intValue() >= Level.INFO.intValue()) {
                System.out.println("Parsing RNAcofold output:");
                for (String s : rnafoldLines) {
                    System.out.println(s);
                }
                System.out.println("Parsed bracked notation: " + bracket);
            }
            predictedInteractions = RnaFoldTools.parseRnacofoldBracketInteractions(bracket);
            predictedInteractions1 = RnaFoldTools.parseRnacofoldBracketSingleInteractions(bracket, true);
            predictedInteractions2 = RnaFoldTools.parseRnacofoldBracketSingleInteractions(bracket, false);
        }
        double result = 0.0;
        if (this.structureWeight != 0.0) {
            result += this.structureWeight * RnaFoldTools.computeMatrixDifference(interactions, predictedInteractions) / 2.0;
            result += this.structureWeight * RnaFoldTools.computeMatrixDifference(interactions1, predictedInteractions1) / 2.0;
            result += this.structureWeight * RnaFoldTools.computeMatrixDifference(interactions2, predictedInteractions2) / 2.0;
        }
        if (this.energyMode) {
            if (!this.pkMode) {
                double energyAB = RnaFoldTools.parseRnacofoldEnergyAB(rnafoldLines);
                double energyAA = RnaFoldTools.parseRnacofoldEnergyAA(rnafoldLines);
                double energyBB = RnaFoldTools.parseRnacofoldEnergyBB(rnafoldLines);
                double energyA = RnaFoldTools.parseRnacofoldEnergyA(rnafoldLines);
                double energyB = RnaFoldTools.parseRnacofoldEnergyB(rnafoldLines);
                double eDiff = energyAB - energyA - energyB;
                double eDiffGap = eDiff + this.energyGap;
                double eDiffAA = energyAB - energyAA;
                double eDiffBB = energyAB - energyBB;
                if (this.isInteracting(interactions)) {
                    if (eDiffGap > 0.0) {
                        result += eDiffGap;
                        this.log.fine("Adding energy penalty (1): " + eDiffGap);
                    }
                    if (eDiffAA > 0.0) {
                        result += eDiffAA;
                        this.log.fine("Adding energy penalty (AA): " + eDiffAA);
                    }
                    if (eDiffBB > 0.0) {
                        result += eDiffBB;
                        this.log.fine("Adding energy penalty (BB): " + eDiffBB);
                    }
                } else if (eDiff < 0.0) {
                    result -= eDiff;
                    this.log.fine("Adding energy penalty (2): " + -eDiff);
                }
            } else {
                this.log.fine("Energy mode not active when pseudoknot mode is switched on.");
            }
        }
        assert (result >= 0.0);
        return result;
    }

    private double scoreStructureSingleSequence(StringBuffer bseq1, int[][] interactions1, String[] rnafoldLines) throws IOException, ParseException {
        assert (interactions1.length == bseq1.length());
        assert (interactions1[0].length == bseq1.length());
        String fusedSequence = "";
        int len1 = bseq1.length();
        if (rnafoldLines == null) {
            rnafoldLines = this.launchFolding(bseq1.toString());
        }
        assert (rnafoldLines != null);
        int[][] predictedInteractions1 = null;
        double energy = 0.0;
        if (this.debugLogLevel.intValue() >= Level.INFO.intValue()) {
            System.out.println("Output of single sequence folding algorithm:");
            for (int i = 0; i < rnafoldLines.length; ++i) {
                System.out.println(rnafoldLines[i]);
            }
        }
        if (this.pkMode) {
            PknotsRGParser parser = new PknotsRGParser();
            MutableSecondaryStructure structure = parser.parse(rnafoldLines);
            assert (structure != null);
            assert (structure.getSequenceCount() == 1);
            predictedInteractions1 = structure.toInteractionMatrix(0, 0);
            assert (predictedInteractions1 != null && predictedInteractions1.length > 0);
            assert (predictedInteractions1.length == predictedInteractions1[0].length);
            if (this.debugLevel > 2) {
                System.out.println("Interactions of single-strand evaluation:");
                IntegerArrayTools.writeMatrix(System.out, predictedInteractions1);
            }
        } else {
            String bracket = RnaFoldTools.parseRnafoldStructure(rnafoldLines);
            predictedInteractions1 = RnaFoldTools.parseBracketInteractions(bracket);
            energy = RnaFoldTools.parseRnafoldEnergy(rnafoldLines);
        }
        double result = 0.0;
        result = this.countMissedMode ? this.structureWeight * RnaFoldTools.countMissedInteractions(interactions1, predictedInteractions1) / 2.0 : this.structureWeight * RnaFoldTools.computeMatrixDifference(interactions1, predictedInteractions1) / 2.0;
        if (!this.isInteracting(interactions1) && energy < this.selfEnergyCutoff) {
            result += this.selfEnergyCutoff - energy;
        }
        assert (result >= 0.0);
        return result;
    }

    private void cacheSeqs(StringBuffer[] bseqs) {
        if (this.lastSeqs == null || this.lastSeqs.length != bseqs.length) {
            this.lastSeqs = new StringBuffer[bseqs.length];
        }
        for (int i = 0; i < bseqs.length; ++i) {
            this.lastSeqs[i] = new StringBuffer(bseqs[i].toString());
        }
    }

    boolean[] findModified(StringBuffer[] bseqs) {
        int i;
        boolean[] result = new boolean[bseqs.length];
        for (i = 0; i < bseqs.length; ++i) {
            result[i] = true;
        }
        if (this.lastSeqs == null || result.length != this.lastSeqs.length) {
            return result;
        }
        for (i = 0; i < bseqs.length; ++i) {
            assert (this.lastSeqs[i] != null);
            assert (bseqs[i] != null);
            result[i] = this.lastSeqs[i].toString().compareTo(bseqs[i].toString()) != 0;
        }
        return result;
    }

    private void initScoreCache(StringBuffer[] bseqs) {
        this.singleSequenceScoreCache = new double[bseqs.length];
        assert (this.singleSequenceScoreCache[0] == 0.0);
        this.sequencePairScoreCache = new double[bseqs.length][bseqs.length];
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        Properties resultProperties = new Properties();
        double score = 0.0;
        boolean[] modified = this.findModified(bseqs);
        if (this.singleSequenceScoreCache == null || this.singleSequenceScoreCache.length != bseqs.length) {
            this.initScoreCache(bseqs);
        }
        double term = 0.0;
        int termCount = 0;
        int cacheCount = 0;
        ArrayList<Integer> singles = new ArrayList<Integer>();
        ArrayList<Integer> pairsA = new ArrayList<Integer>();
        ArrayList<Integer> pairsB = new ArrayList<Integer>();
        String[] rnacofoldLines = new String[7];
        String[] rnafoldLines = new String[2];
        for (int i = 0; i < bseqs.length; ++i) {
            if (!structure.isActive(i)) continue;
            if (this.interStrandMode) {
                for (int j = i + 1; j < bseqs.length; ++j) {
                    if (!structure.isActive(j)) continue;
                    if (modified[i] || modified[j]) {
                        pairsA.add(i);
                        pairsB.add(j);
                    } else {
                        score += this.sequencePairScoreCache[i][j];
                        ++cacheCount;
                    }
                    ++termCount;
                }
            }
            if (modified[i]) {
                singles.add(i);
            } else {
                score += this.singleSequenceScoreCache[i];
                ++cacheCount;
            }
            ++termCount;
        }
        assert (pairsA.size() == pairsB.size());
        try {
            String[] rnafoldCombined;
            int i;
            if (pairsA.size() > 0) {
                StringBuffer rnacofoldInput = new StringBuffer();
                for (int k = 0; k < pairsA.size(); ++k) {
                    int i2 = (Integer)pairsA.get(k);
                    int j = (Integer)pairsB.get(k);
                    rnacofoldInput.append(this.generateFusedSequence(bseqs[i2].toString(), bseqs[j].toString()) + PackageConstants.NEWLINE);
                }
                String[] combinedResult = this.launchFolding(rnacofoldInput.toString());
                System.out.println("Combined RNAcofold result:");
                for (String s : combinedResult) {
                    System.out.println(s);
                }
                for (int k = 0; k < pairsA.size(); ++k) {
                    i = (Integer)pairsA.get(k);
                    int j = (Integer)pairsB.get(k);
                    int startLine = k * 7;
                    for (int kk = 0; kk < 7; ++kk) {
                        if (startLine + kk >= combinedResult.length) {
                            throw new ParseException("Combined RNAcofold result appears to be incomplete.", startLine + kk);
                        }
                        rnacofoldLines[kk] = combinedResult[startLine + kk];
                    }
                    this.sequencePairScoreCache[i][j] = term = this.scoreStructureSequencePair(bseqs[i], bseqs[j], interactionMatrices[i][j], interactionMatrices[i][i], interactionMatrices[j][j], rnacofoldLines);
                    this.sequencePairScoreCache[j][i] = term;
                    score += term;
                    System.out.println("Term for sequence pair " + i + " " + j + " " + term);
                }
            }
            StringBuffer rnafoldInput = new StringBuffer();
            for (int k = 0; k < singles.size(); ++k) {
                int i3 = (Integer)singles.get(k);
                rnafoldInput.append(bseqs[i3]);
                rnafoldInput.append(PackageConstants.NEWLINE);
            }
            System.out.println("RNAFOLD combined result:\n");
            for (String s : rnafoldCombined = this.launchFolding(rnafoldInput.toString())) {
                System.out.println(s);
            }
            for (int k = 0; k < singles.size(); ++k) {
                i = (Integer)singles.get(k);
                int startLine = k * 2;
                for (int kk = 0; kk < 2; ++kk) {
                    if (startLine + kk >= rnafoldCombined.length) {
                        throw new ParseException("Combined RNAfold result appears to be incomplete.", startLine + kk);
                    }
                    rnafoldLines[kk] = rnafoldCombined[startLine + kk];
                }
                this.singleSequenceScoreCache[i] = term = this.scoreStructureSingleSequence(bseqs[i], interactionMatrices[i][i], rnafoldLines);
                score += term;
            }
        }
        catch (IOException ioe) {
            this.log.severe("Error launching RNAcofold! Error message: " + ioe.getMessage());
            resultProperties.setProperty("error", "Error launching RNAcofold! Error message: " + ioe.getMessage());
            assert (false);
            return resultProperties;
        }
        catch (ParseException pe) {
            this.log.severe("Error parsing RNAcofold results! Error message: " + pe.getMessage());
            resultProperties.setProperty("error", "Error parsing RNAcofold! Error message: " + pe.getMessage());
            assert (false);
            return resultProperties;
        }
        assert (score >= 0.0);
        if (this.subScorer != null && this.subScorerWeight != 0.0) {
            score += this.subScorerWeight * this.subScorer.scoreStructure(bseqs, structure, interactionMatrices);
        }
        assert (termCount > 0);
        this.cacheSeqs(bseqs);
        resultProperties.setProperty("score", "" + score);
        return resultProperties;
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public void setEnergyGap(double value) {
        this.energyGap = value;
    }

    public void setEnergyMode(boolean b) {
        this.energyMode = b;
    }

    public void setInterStrandMode(boolean mode) {
        this.interStrandMode = mode;
    }

    public void setPkMode(boolean mode) {
        this.pkMode = mode;
    }

    public void setSubScorer(SecondaryStructureScorer scorer) {
        this.subScorer = scorer;
    }

    public void setSelfEnergyCutoff(double cutoff) {
        this.selfEnergyCutoff = cutoff;
    }

    public void setStructureWeight(double weight) {
        this.structureWeight = weight;
    }

    public void setSubScorerWeight(double weight) {
        this.subScorerWeight = weight;
    }
}

