/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

import generaltools.ParsingException;
import generaltools.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import numerictools.AccuracyTools;
import numerictools.IntervalInt;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import secondarystructuredesign.RnaFoldTools;
import secondarystructuredesign.SecondaryStructureScorer;

public class RnafoldSecondaryStructureScorer
implements SecondaryStructureScorer {
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("SecondaryStructureDesign");
    private static String rnaFoldScriptName = rb.getString("rnafoldscript");
    private double energyAU = -0.8;
    private double energyGC = -1.2;
    private String linkerSequence = "AAAA";

    public String getLinkerSequence() {
        return this.linkerSequence;
    }

    public void setLinkerSequence(String s) {
        this.linkerSequence = s;
    }

    public double interactionEnergy(char c1, char c2) {
        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
            return 0.0;
        }
        if (c1 > c2) {
            return this.interactionEnergy(c2, c1);
        }
        switch (c1) {
            case 'A': {
                if (c2 == 'U') {
                    return this.energyAU;
                }
            }
            case 'C': {
                if (c2 != 'G') break;
                return this.energyGC;
            }
        }
        return 0.0;
    }

    String[] launchRnafold(String sequence) throws IOException {
        File tmpInputFile = File.createTempFile("nanotiler_rnafold", ".sec");
        String inputFileName = tmpInputFile.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(tmpInputFile);
        PrintStream ps = new PrintStream(fos);
        SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
        this.log.fine("Writing to file: " + inputFileName);
        this.log.fine("Writing content: " + sequence);
        ps.println(sequence);
        fos.close();
        File tmpOutputFile = File.createTempFile("nanotiler_rnafold", ".seq");
        String outputFileName = tmpOutputFile.getAbsolutePath();
        if (tmpOutputFile.exists()) {
            tmpOutputFile.delete();
        }
        File tempFile = new File(rnaFoldScriptName);
        String[] commandWords = new String[]{rnaFoldScriptName, inputFileName, outputFileName};
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        this.log.fine("queue manager finished job!");
        this.log.fine("Importing optimized sequences from " + outputFileName);
        String[] resultLines = null;
        try {
            FileInputStream resultFile = new FileInputStream(outputFileName);
            resultLines = StringTools.readAllLines(resultFile);
        }
        catch (IOException ioe) {
            this.log.warning("Error when scraping result file from: " + outputFileName);
            throw ioe;
        }
        return resultLines;
    }

    private double computeMatrixMatthews(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            block5: for (int j = i + 1; j < trueInteractions[0].length; ++j) {
                int pv = predictedInteractions[i][j];
                int tv = trueInteractions[i][j];
                switch (tv) {
                    case 1: {
                        if (pv == 1) {
                            ++tp;
                            continue block5;
                        }
                        ++fn;
                        continue block5;
                    }
                    case -1: {
                        if (pv == 1) {
                            ++fp;
                            continue block5;
                        }
                        ++tn;
                        continue block5;
                    }
                    default: {
                        assert (false);
                        continue block5;
                    }
                }
            }
        }
        return AccuracyTools.computeMatthews(tp, fp, tn, fn);
    }

    private double computeMatrixDifference(int[][] trueInteractions, int[][] predictedInteractions) {
        assert (trueInteractions.length == predictedInteractions.length);
        assert (trueInteractions[0].length == predictedInteractions[0].length);
        int count = 0;
        for (int i = 0; i < trueInteractions.length; ++i) {
            for (int j = 0; j < trueInteractions[0].length; ++j) {
                if (trueInteractions[i][j] == predictedInteractions[i][j]) continue;
                ++count;
            }
        }
        return count;
    }

    private int findInnerInteraction(String s, int n) {
        if (s.charAt(n) != '(') {
            return -1;
        }
        for (int i = n + 1; i < s.length(); ++i) {
            if (s.charAt(i) == ')') {
                return i;
            }
            if (s.charAt(i) != '(') continue;
            return -1;
        }
        return -1;
    }

    private IntervalInt findInnerInteraction(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int j = this.findInnerInteraction(s, i);
            if (j < 0) continue;
            return new IntervalInt(i, j);
        }
        return null;
    }

    private int[][] parseBracketInteractions(String structure) {
        int foundInteractions;
        assert (structure != null);
        int len = structure.length();
        int[][] result = new int[len][len];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = -1;
            }
        }
        int numInteractions = StringTools.countChar(structure, '(');
        StringBuffer buf = new StringBuffer(structure);
        for (foundInteractions = 0; foundInteractions < numInteractions; ++foundInteractions) {
            IntervalInt intervall = this.findInnerInteraction(buf.toString());
            if (intervall == null) {
                this.log.info("Could not find inner interactions in: " + structure);
                break;
            }
            int j = intervall.getLower();
            int k = intervall.getUpper();
            this.log.fine("Found interaction");
            this.log.fine("Structure: " + structure);
            this.log.fine("Interaction: " + j + "   " + k);
            result[j][k] = 1;
            result[k][j] = 1;
            buf.setCharAt(j, '.');
            buf.setCharAt(k, '.');
        }
        assert (foundInteractions == numInteractions);
        return result;
    }

    private double scoreStructureSequence(StringBuffer bseq, int[][] interactions) throws IOException, ParsingException {
        assert (interactions.length == bseq.length());
        double score = 0.0;
        String[] rnafoldLines = this.launchRnafold(bseq.toString());
        String bracket = RnaFoldTools.parseRnafoldStructure(rnafoldLines);
        int[][] predictedInteractions = this.parseBracketInteractions(bracket);
        double result = this.computeMatrixDifference(interactions, predictedInteractions) / 2.0;
        this.log.fine("Matrix difference for comparing desired and predicted structure: " + result + " " + bracket);
        return result;
    }

    private String generateFusedSequence(String s1, String s2) {
        return s1 + this.linkerSequence + s2;
    }

    private int[][] generateFusedInteractions(int[][] interactions, boolean orderFlag) {
        int j;
        int i;
        int linkLen = this.linkerSequence.length();
        int l1 = interactions.length;
        int l2 = interactions[0].length;
        int fusedLen = l1 + linkLen + l2;
        assert (fusedLen > 0);
        int[][] result = new int[fusedLen][fusedLen];
        for (i = 0; i < result.length; ++i) {
            for (j = 0; j < result[0].length; ++j) {
                result[i][j] = -1;
            }
        }
        for (i = 0; i < interactions.length; ++i) {
            for (j = 0; j < interactions[0].length; ++j) {
                if (interactions[i][j] != 1) continue;
                int id1 = i;
                int id2 = j + l1 + linkLen;
                if (!orderFlag) {
                    id1 = j;
                    id2 = i + l2 + linkLen;
                }
                assert (id1 < result.length);
                assert (id2 < result[0].length);
                result[id1][id2] = 1;
                result[id2][id1] = 1;
            }
        }
        return result;
    }

    private double scoreStructureSequencePair(StringBuffer bseq1, StringBuffer bseq2, int[][] interactions, boolean orderFlag) throws IOException, ParsingException {
        assert (interactions.length == bseq1.length());
        assert (interactions[0].length == bseq2.length());
        int[][] fusedInteractions = this.generateFusedInteractions(interactions, orderFlag);
        assert (fusedInteractions.length == fusedInteractions[0].length);
        String fusedSequence = "";
        fusedSequence = orderFlag ? this.generateFusedSequence(bseq1.toString(), bseq2.toString()) : this.generateFusedSequence(bseq2.toString(), bseq1.toString());
        String[] rnafoldLines = this.launchRnafold(fusedSequence);
        String bracket = RnaFoldTools.parseRnafoldStructure(rnafoldLines);
        int[][] predictedInteractions = this.parseBracketInteractions(bracket);
        double result = this.computeMatrixDifference(fusedInteractions, predictedInteractions) / 2.0;
        this.log.fine("Matrix difference for comparing fused desired and predicted structure: " + result + " " + bracket);
        return result;
    }

    @Override
    public double scoreStructure(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        String scoreString = this.generateReport(bseqs, structure, interactionMatrices, 0).getProperty("score");
        assert (scoreString != null);
        return Double.parseDouble(scoreString);
    }

    @Override
    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices) {
        return this.generateReport(bseqs, structure, interactionMatrices, 10);
    }

    public Properties generateReport(StringBuffer[] bseqs, SecondaryStructure structure, int[][][][] interactionMatrices, int verbosity) {
        Properties resultProperties = new Properties();
        double score = 0.0;
        try {
            for (int i = 0; i < bseqs.length; ++i) {
                score += this.scoreStructureSequence(bseqs[i], interactionMatrices[i][i]);
                for (int j = i + 1; j < bseqs.length; ++j) {
                    score += 0.5 * this.scoreStructureSequencePair(bseqs[i], bseqs[j], interactionMatrices[i][j], true);
                    score += 0.5 * this.scoreStructureSequencePair(bseqs[i], bseqs[j], interactionMatrices[i][j], false);
                }
            }
        }
        catch (IOException ioe) {
            this.log.severe("Error launching RNAfold! Error message: " + ioe.getMessage());
            return resultProperties;
        }
        catch (ParsingException pe) {
            this.log.severe("Error parsing RNAfold results! Error message: " + pe.getMessage());
            return resultProperties;
        }
        resultProperties.setProperty("score", "" + score);
        return resultProperties;
    }
}

