/*
 * Decompiled with CFR 0.152.
 */
package secondarystructuredesign;

public class Strand {
    private int index;
    private int length;
    private StringBuffer sequence;
    private StringBuffer constraints;
    private boolean inComplex = false;

    public Strand() {
    }

    public Strand(StringBuffer sequence, int index) {
        this.index = index;
        this.length = sequence.length();
        this.sequence = sequence;
        this.constraints = new StringBuffer(this.length);
        for (int i = 0; i < this.length; ++i) {
            this.constraints.append('.');
        }
    }

    public Strand(StringBuffer sequence, StringBuffer constraints, int index) {
        assert (sequence.length() == constraints.length());
        this.index = index;
        this.length = sequence.length();
        this.sequence = sequence;
        this.constraints = constraints;
    }

    public void addToComplex() {
        this.inComplex = true;
    }

    public void removeFromComplex() {
        this.inComplex = false;
    }

    public boolean isInComplex() {
        return this.inComplex;
    }

    public void addConstraints(StringBuffer bondingPattern) {
        assert (bondingPattern.length() == this.constraints.length());
        for (int i = 0; i < bondingPattern.length(); ++i) {
            if (bondingPattern.charAt(i) != 'x') continue;
            this.constraints.setCharAt(i, 'x');
        }
    }

    public StringBuffer getSequence() {
        return this.sequence;
    }

    public StringBuffer getConstraints() {
        return this.constraints;
    }

    public int index() {
        return this.index;
    }
}

