/*
 * Decompiled with CFR 0.152.
 */
package sequence;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import sequence.Alphabet;
import sequence.DnaTools;
import sequence.Sequence;
import sequence.SequenceIOException;
import sequence.SequenceSubset;
import sequence.SimpleSequence;
import sequence.UnknownSymbolException;

public class SequenceReader {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public void readSequenceSubsetBody(InputStream fis, SequenceSubset subset) throws SequenceIOException {
        DataInputStream dis = new DataInputStream(fis);
        String expected = "(sequence";
        String word = SequenceReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new SequenceIOException("SequenceBindingSite: " + expected + " excepted instead of " + word);
        }
        Sequence sequence = this.readSequenceBody(dis);
        expected = ")";
        word = SequenceReader.readWord(dis);
        if (!word.equals(expected)) {
            throw new SequenceIOException("SequenceBindingSite: " + expected + " excepted instead of " + word);
        }
        subset.setSequence(sequence);
        word = SequenceReader.readWord(dis);
        int seqLen = 0;
        try {
            seqLen = Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw new SequenceIOException("SequenceBindingSite: Could not parse length of sequence: " + word);
        }
        for (int i = 0; i < seqLen; ++i) {
            word = SequenceReader.readWord(dis);
            int index = 0;
            try {
                index = Integer.parseInt(word);
            }
            catch (NumberFormatException e) {
                throw new SequenceIOException("SequenceBindingSite: Could not parse index of sequence: " + word);
            }
            subset.addIndex(index);
        }
    }

    public Sequence readSequenceBody(InputStream is) throws SequenceIOException {
        Alphabet alphabet;
        DataInputStream dis = new DataInputStream(is);
        String word = SequenceReader.readWord(dis);
        int sequenceType = 0;
        if (word.equals("DNA")) {
            sequenceType = 2;
            alphabet = DnaTools.DNA_ALPHABET;
        } else if (word.equals("RNA")) {
            sequenceType = 4;
            alphabet = DnaTools.RNA_ALPHABET;
        } else if (word.equals("DNA_A")) {
            sequenceType = 1;
            alphabet = DnaTools.AMBIGUOUS_DNA_ALPHABET;
        } else if (word.equals("RNA_A")) {
            sequenceType = 3;
            alphabet = DnaTools.AMBIGUOUS_RNA_ALPHABET;
        } else {
            log.severe("sequence type not yet implemented: " + word);
            throw new SequenceIOException("sequence type not yet implemented: " + word);
        }
        String name = SequenceReader.readWord(dis);
        String seq = SequenceReader.readWord(dis);
        SimpleSequence sequence = null;
        try {
            sequence = new SimpleSequence(seq, name, alphabet);
        }
        catch (UnknownSymbolException e) {
            throw new SequenceIOException("unknown sequence characters found in sequence: " + name);
        }
        return sequence;
    }

    public static String readWord(DataInputStream dis) {
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            log.finest("found word: " + s);
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        log.finest("found word: " + s);
        return s;
    }
}

