/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.TestTools;
import org.testng.annotations.Test;
import tools3d.Matrix3D;
import tools3d.Matrix4D;
import tools3d.Vector3D;
import tools3d.Vector4D;

public class AxisAngle {
    private double angle;
    private Vector3D axis;

    public AxisAngle() {
        this.angle = 0.0;
        this.axis = new Vector3D(0.0, 0.0, 0.0);
    }

    public AxisAngle(double angle, double x, double y, double z) {
        this.angle = angle;
        this.axis = new Vector3D(x, y, z);
        this.axis.normalize();
    }

    public AxisAngle(double angle, Vector3D axis) {
        this.angle = angle;
        this.axis = new Vector3D(axis);
        this.axis.normalize();
    }

    public AxisAngle(AxisAngle other) {
        this(other.getAngle(), other.getAxis());
    }

    public AxisAngle(Matrix3D m) {
        this(AxisAngle.toAxisAngle(m));
    }

    public Vector3D getAxis() {
        return this.axis;
    }

    public double getAngle() {
        return this.angle;
    }

    public static AxisAngle toAxisAngle(double[][] m) {
        assert (m.length == 3);
        assert (m[0].length == 3);
        double epsilon = 0.01;
        if (Math.abs(m[0][1] - m[1][0]) < epsilon && Math.abs(m[0][2] - m[2][0]) < epsilon && Math.abs(m[1][2] - m[2][1]) < epsilon) {
            boolean yzPositive;
            if (Math.abs(m[0][1] + m[1][0]) < 0.1 && Math.abs(m[0][2] + m[2][0]) < 0.1 && Math.abs(m[1][2] + m[2][1]) < 0.1 && Math.abs(m[0][0] + m[1][1] + m[2][2]) - 3.0 < 0.1) {
                return new AxisAngle(0.0, 1.0, 0.0, 0.0);
            }
            double angle = Math.PI;
            double x = (m[0][0] + 1.0) / 2.0;
            x = x > 0.0 ? Math.sqrt(x) : 0.0;
            double y = (m[1][1] + 1.0) / 2.0;
            y = y > 0.0 ? Math.sqrt(y) : 0.0;
            double z = (m[2][2] + 1.0) / 2.0;
            z = z > 0.0 ? Math.sqrt(z) : 0.0;
            boolean xZero = Math.abs(x) < epsilon;
            boolean yZero = Math.abs(y) < epsilon;
            boolean zZero = Math.abs(z) < epsilon;
            boolean xyPositive = m[0][1] > 0.0;
            boolean xzPositive = m[0][2] > 0.0;
            boolean bl = yzPositive = m[1][2] > 0.0;
            if (xZero && !yZero && !zZero) {
                if (!yzPositive) {
                    y = -y;
                }
            } else if (yZero && !zZero) {
                if (!xzPositive) {
                    z = -z;
                }
            } else if (zZero && !xyPositive) {
                x = -x;
            }
            return new AxisAngle(angle, x, y, z);
        }
        double s = Math.sqrt((m[2][1] - m[1][2]) * (m[2][1] - m[1][2]) + (m[0][2] - m[2][0]) * (m[0][2] - m[2][0]) + (m[1][0] - m[0][1]) * (m[1][0] - m[0][1]));
        if (Math.abs(s) < 0.001) {
            s = 1.0;
        }
        double angle = Math.acos((m[0][0] + m[1][1] + m[2][2] - 1.0) / 2.0);
        double x = (m[2][1] - m[1][2]) / s;
        double y = (m[0][2] - m[2][0]) / s;
        double z = (m[1][0] - m[0][1]) / s;
        return new AxisAngle(angle, x, y, z);
    }

    public static AxisAngle toAxisAngle(Matrix3D m) {
        return AxisAngle.toAxisAngle(m.toArray());
    }

    public Vector4D toQuaternion() {
        double theta = this.getAngle();
        double w = Math.cos(theta / 2.0);
        double x = this.axis.getX() * Math.sin(theta / 2.0);
        double y = this.axis.getY() * Math.sin(theta / 2.0);
        double z = this.axis.getZ() * Math.sin(theta / 2.0);
        return new Vector4D(x, y, z, w);
    }

    public static AxisAngle fromQuaternion(Vector4D q) {
        double qz;
        double qy;
        double qx = q.getX();
        double scale = Math.sqrt(qx * qx + (qy = q.getY()) * qy + (qz = q.getZ()) * qz);
        if (scale == 0.0) {
            return new AxisAngle(0.0, 0.0, 0.0, 1.0);
        }
        double ax = qx / scale;
        double ay = qy / scale;
        double az = qz / scale;
        double angle = 2.0 * Math.acos(q.getW());
        return new AxisAngle(angle, ax, ay, az);
    }

    public static double distanceAngleSquareNorm(Matrix4D m4, double angleWeight) {
        double distNorm = m4.subvector().length();
        assert (distNorm >= 0.0);
        AxisAngle axisAngle = AxisAngle.toAxisAngle(m4.submatrix());
        double angle = axisAngle.getAngle();
        assert (angle >= 0.0);
        double angleNorm = angle * angle * angleWeight;
        return distNorm + angleNorm;
    }

    public static double distanceQuatNorm(Matrix4D m1, Matrix4D m2, double angleWeight) {
        double distNorm = m2.subvector().distance(m1.subvector());
        assert (distNorm >= 0.0);
        AxisAngle aa1 = new AxisAngle(m1.submatrix());
        AxisAngle aa2 = new AxisAngle(m2.submatrix());
        Vector4D q1 = aa1.toQuaternion();
        Vector4D q2 = aa2.toQuaternion();
        double qDist = q1.minus(q2).length();
        double angleNorm = angleWeight * qDist;
        return distNorm + angleNorm;
    }

    public static double distanceAngleNorm(Matrix4D m4, double angleWeight) {
        double distNorm = m4.subvector().length();
        assert (distNorm >= 0.0);
        AxisAngle axisAngle = AxisAngle.toAxisAngle(m4.submatrix());
        double angle = axisAngle.getAngle();
        assert (angle >= 0.0);
        double angleNorm = angle * angleWeight;
        return distNorm + angleNorm;
    }

    public Matrix3D generateMatrix() {
        double c = Math.cos(this.angle);
        double s = Math.sin(this.angle);
        double t = 1.0 - c;
        Vector3D v = new Vector3D(this.axis);
        v.normalize();
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        double xx = t * x * x + c;
        double xy = t * x * y - z * s;
        double xz = t * x * z + y * s;
        double yx = t * x * y + z * s;
        double yy = t * y * y + c;
        double yz = t * y * z - x * s;
        double zx = t * x * z - y * s;
        double zy = t * y * z + x * s;
        double zz = t * z * z + c;
        return new Matrix3D(xx, xy, xz, yx, yy, yz, zx, zy, zz);
    }

    @Test(groups={"new"})
    public void testGenerateMatrix() {
        String methodName = "testGenerateMatrix";
        System.out.println(TestTools.generateMethodHeader(methodName));
        double angle = 0.7853981633974483;
        Vector3D axis = new Vector3D(1.0, 2.0, 3.0);
        AxisAngle axisAngle = new AxisAngle(angle, axis);
        Matrix3D matrix = axisAngle.generateMatrix();
        AxisAngle axisAngle2 = new AxisAngle(matrix);
        assert (Math.abs(axisAngle.getAngle() - axisAngle2.getAngle()) < 0.1);
        assert (axisAngle.getAxis().distance(axisAngle2.getAxis()) < 0.1);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }
}

