/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.Randomizer;
import java.util.Random;
import java.util.logging.Logger;
import tools3d.Orientable;
import tools3d.OrientableModifier;
import tools3d.Vector3D;
import tools3d.Vector3DTools;

public class GaussianOrientableMutator
implements OrientableModifier {
    private static Random rnd = Randomizer.getInstance();
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private double angleStep;
    private Vector3D fixedAxis = null;
    private double translationStep;

    public GaussianOrientableMutator(double translationStep, double angleStep) {
        this.translationStep = translationStep;
        this.angleStep = angleStep;
    }

    public boolean isValid() {
        return !(this.angleStep <= 0.0) && !(this.translationStep < 0.0) && !Double.isNaN(this.angleStep) && !Double.isInfinite(this.angleStep) && !Double.isNaN(this.translationStep) && !Double.isInfinite(this.translationStep);
    }

    public void copy(GaussianOrientableMutator other) {
        this.angleStep = other.angleStep;
        this.fixedAxis = other.fixedAxis;
        this.translationStep = other.translationStep;
    }

    @Override
    public void mutate(Orientable obj) {
        this.rotate(obj);
        this.translate(obj);
    }

    @Override
    public void rotate(Orientable obj) {
        assert (this.isValid());
        assert (obj.isValid());
        assert (this.angleStep > 0.0);
        Vector3D axis = this.fixedAxis;
        if (this.fixedAxis == null) {
            axis = Vector3DTools.generateRandomDirection();
        }
        assert (axis.isValid());
        assert (axis.length() > 0.0);
        double angle = this.angleStep * rnd.nextGaussian();
        assert (!Double.isNaN(angle));
        assert (!Double.isInfinite(angle));
        Vector3D pos1 = obj.getPosition();
        obj.rotate(axis, angle);
        Vector3D pos2 = obj.getPosition();
        assert (pos1.distance(pos2) < 0.01);
        if (!obj.isValid()) {
            log.severe("Could not rotate object with axis: " + axis + " and angle " + angle + " " + obj.getPosition());
        }
        assert (obj.isValid());
    }

    @Override
    public double getAngleStep() {
        return this.angleStep;
    }

    @Override
    public double getTranslationStep() {
        return this.translationStep;
    }

    @Override
    public void setAngleStep(double d) {
        this.angleStep = d;
        assert (this.isValid());
    }

    public void setFixedAxis(Vector3D axis) {
        assert (axis != null);
        this.fixedAxis = new Vector3D(axis);
    }

    @Override
    public void setTranslationStep(double d) {
        this.translationStep = d;
        assert (this.isValid());
    }

    @Override
    public void translate(Orientable obj) {
        Vector3D direction = Vector3DTools.generateRandomDirection();
        double translationScale = this.translationStep * rnd.nextGaussian();
        obj.translate(direction.mul(translationScale));
        assert (obj.isValid());
    }

    @Override
    public void scaleAngleStep(double scale) {
        this.angleStep *= scale;
        assert (this.isValid());
    }

    @Override
    public void scaleTranslationStep(double scale) {
        this.translationStep *= scale;
        assert (this.isValid());
    }

    public String toString() {
        return "" + this.translationStep + " " + 57.29577951308232 * this.angleStep;
    }
}

