/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import generaltools.Randomizer;
import java.util.Random;
import tools3d.Matrix3D;
import tools3d.Vector3D;
import tools3d.Vector3DTools;

public class SuperpositionTools {
    private static Random rand = Randomizer.getInstance();

    public static Vector3D generateRandomVector(double len) {
        assert (len > 0.0);
        return SuperpositionTools.generateRandomVector(len, rand);
    }

    public static Vector3D generateRandomVector(double len, Random rand) {
        assert (len > 0.0);
        double phi = Math.PI * 2 * rand.nextDouble();
        double theta = Math.PI * rand.nextDouble();
        double r = len;
        double x = r * Math.cos(phi) * Math.sin(theta);
        double y = r * Math.sin(phi) * Math.sin(theta);
        double z = r * Math.cos(theta);
        Vector3D result = new Vector3D(x, y, z);
        assert (Math.abs(result.length() - len) < 0.01);
        return result;
    }

    public static Matrix3D generateRandomMatrix() {
        Vector3D dir = SuperpositionTools.generateRandomVector(1.0, rand);
        double angle = Math.PI * 2 * rand.nextDouble();
        return Matrix3D.rotationMatrix(dir, angle);
    }

    public static Matrix3D randomRotate(Vector3D[] v) {
        Matrix3D mtx = SuperpositionTools.generateRandomMatrix();
        for (int i = 0; i < v.length; ++i) {
            v[i] = mtx.multiply(v[i]);
        }
        return mtx;
    }

    public static Matrix3D randomRotateAroundOrigin(Vector3D[] v) {
        Matrix3D mtx = SuperpositionTools.generateRandomMatrix();
        Vector3D center = Vector3DTools.computeCenterGravity(v);
        for (int i = 0; i < v.length; ++i) {
            v[i].sub(center);
            v[i] = mtx.multiply(v[i]);
            v[i].add(center);
        }
        return mtx;
    }
}

