/*
 * Decompiled with CFR 0.152.
 */
package tools3d;

import tools3d.Junction;
import tools3d.Point;
import tools3d.Symmetry;
import tools3d.Vector3D;

public class SymmetryLink {
    private Junction junction;
    private Junction junctionSym;
    private Point point;
    private Point pointSym;

    public SymmetryLink() {
    }

    public SymmetryLink(Junction junction, Point point, Junction junctionSym, Point pointSym, Symmetry symmetry) {
        this.setJunction((Junction)junction.cloneDeep());
        this.setPoint((Point)point.cloneDeep());
        this.setJunctionSym((Junction)junctionSym.cloneDeep(), (Symmetry)symmetry.cloneDeep());
        this.setPointSym((Point)pointSym.cloneDeep(), (Symmetry)symmetry.cloneDeep());
    }

    public Object cloneDeep() {
        SymmetryLink sl = new SymmetryLink();
        sl.copyDeepThisCore(this);
        return sl;
    }

    protected void copyDeepThisCore(SymmetryLink sl) {
        this.junction = (Junction)sl.junction.cloneDeep();
        this.point = (Point)sl.point.cloneDeep();
        this.junctionSym = (Junction)sl.junctionSym.cloneDeep();
        this.pointSym = (Point)sl.pointSym.cloneDeep();
    }

    public Junction getJunction() {
        return this.junction;
    }

    public Junction getJunctionSym() {
        return this.junctionSym;
    }

    public Point getPoint() {
        return this.point;
    }

    public Point getPointSym() {
        return this.pointSym;
    }

    public void setJunction(Junction junction) {
        this.junction = junction;
    }

    public void setJunctionSym(Junction junctionSym, Symmetry symmetry) {
        Vector3D start = symmetry.getStartPoint().getVector3D();
        Vector3D end = symmetry.getEndPoint().getVector3D();
        Vector3D axis = end.minus(start);
        junctionSym.rotate(start, axis, Math.PI * 2 / (double)symmetry.getType());
        this.junctionSym = junctionSym;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public void setPointSym(Point pointSym, Symmetry symmetry) {
        Vector3D start = symmetry.getStartPoint().getVector3D();
        Vector3D end = symmetry.getEndPoint().getVector3D();
        Vector3D axis = end.minus(start);
        pointSym.rotate(start, axis, Math.PI * 2 / (double)symmetry.getType());
        this.pointSym = pointSym;
    }

    public String toString() {
        String s = new String("( SymmetryLink: " + this.point + " in Junction " + this.junction.getName() + " links to " + this.point + " in Junction " + this.junctionSym.getName() + " )");
        return s;
    }
}

