/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d.modeling;

import java.util.ArrayList;
import java.util.List;
import tools3d.Orientable;
import tools3d.SimpleOrientable;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DEmptyVisitor;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.modeling.CoordinateSnapShot;

public class SimpleCoordinateSnapShot
implements CoordinateSnapShot {
    private List<SimpleOrientable> coordinates = new ArrayList<SimpleOrientable>();
    private Object3D prototype = null;

    public SimpleCoordinateSnapShot(Object3D objects) {
        Object3DEmptyVisitor visitor = new Object3DEmptyVisitor(objects);
        while (visitor.hasNext()) {
            SimpleOrientable orientable = new SimpleOrientable();
            orientable.copyDeep((Object3D)visitor.next());
            this.coordinates.add(orientable);
        }
    }

    public SimpleCoordinateSnapShot(Object3DSet objects) {
        for (int i = 0; i < objects.size(); ++i) {
            SimpleOrientable orientable = new SimpleOrientable();
            orientable.copyDeep(objects.get(i));
            this.coordinates.add(orientable);
        }
    }

    public SimpleCoordinateSnapShot(Vector3D[] positions) {
        for (int i = 0; i < positions.length; ++i) {
            SimpleOrientable orientable = new SimpleOrientable();
            orientable.setPosition(positions[i]);
            this.coordinates.add(orientable);
        }
    }

    public SimpleCoordinateSnapShot(Object3DSet objects, Object3D prototype) {
        this.prototype = prototype;
        for (int i = 0; i < objects.size(); ++i) {
            Object3D obj = objects.get(i);
            if (!obj.getClassName().equals(prototype.getClassName())) continue;
            SimpleOrientable orientable = new SimpleOrientable();
            orientable.copyDeep(obj);
            this.coordinates.add(orientable);
        }
    }

    public SimpleCoordinateSnapShot(Object3D objects, Object3D prototype) {
        Object3DEmptyVisitor visitor = new Object3DEmptyVisitor(objects);
        this.prototype = prototype;
        while (visitor.hasNext()) {
            Object3D obj = (Object3D)visitor.next();
            if (!obj.getClassName().equals(prototype.getClassName())) continue;
            SimpleOrientable orientable = new SimpleOrientable();
            orientable.copyDeep(obj);
            this.coordinates.add(orientable);
        }
    }

    @Override
    public void applySnapShot(Object3D objects) {
        Object3DEmptyVisitor visitor = new Object3DEmptyVisitor(objects);
        int pc = 0;
        while (visitor.hasNext()) {
            Object3D obj = (Object3D)visitor.next();
            if (this.prototype != null && !obj.getClassName().equals(this.prototype.getClassName())) continue;
            SimpleOrientable orientable = this.coordinates.get(pc++);
            this.applySnapShot(obj, orientable);
        }
    }

    @Override
    public void applySnapShot(Object3DSet objects) {
        int pc = 0;
        int i = 0;
        while (i < this.coordinates.size()) {
            Object3D obj = objects.get(pc);
            if (this.prototype != null) {
                while (pc < objects.size() && !obj.getClassName().equals(this.prototype.getClassName())) {
                    obj = objects.get(++pc);
                }
            }
            if (this.prototype == null || obj.getClassName().equals(this.prototype.getClassName())) {
                SimpleOrientable orientable = this.coordinates.get(i);
                this.applySnapShot(obj, orientable);
            }
            ++i;
            ++pc;
        }
    }

    public void applySnapShot(Object3D obj, Orientable orient) {
        obj.setPosition(orient.getPosition());
        obj.setRotationAngle(orient.getRotationAngle());
        obj.setZBufValue(orient.getZBufValue());
        obj.setRotationAxis(orient.getRotationAxis());
    }

    @Override
    public Orientable getCoordinate(int n) {
        return this.coordinates.get(n);
    }

    @Override
    public int size() {
        return this.coordinates.size();
    }
}

