/*
 * Decompiled with CFR 0.152.
 */
package tools3d.objects3d.modeling;

import java.util.ArrayList;
import java.util.List;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.modeling.FlexibleForceField;
import tools3d.objects3d.modeling.ForceFieldLinkPairElement;
import tools3d.objects3d.modeling.ForceFieldPairElement;

public class SimpleFlexibleForceField
implements FlexibleForceField {
    private List<ForceFieldPairElement> pairForceFields = new ArrayList<ForceFieldPairElement>();
    private List<ForceFieldLinkPairElement> linkPairForceFields = new ArrayList<ForceFieldLinkPairElement>();

    @Override
    public void addForceFieldPairElement(ForceFieldPairElement ff) {
        this.pairForceFields.add(ff);
    }

    @Override
    public int forceFieldPairElementCount() {
        return this.pairForceFields.size();
    }

    @Override
    public ForceFieldPairElement getForceFieldPairElement(int n) {
        return this.pairForceFields.get(n);
    }

    @Override
    public void addForceFieldLinkPairElement(ForceFieldLinkPairElement ff) {
        this.linkPairForceFields.add(ff);
    }

    @Override
    public int forceFieldLinkPairElementCount() {
        return this.linkPairForceFields.size();
    }

    @Override
    public ForceFieldLinkPairElement getForceFieldLinkPairElement(int n) {
        return this.linkPairForceFields.get(n);
    }

    @Override
    public double energy(Object3DSet objects, LinkSet links) {
        int j;
        int i;
        double result = 0.0;
        for (i = 1; i < objects.size(); ++i) {
            for (j = 0; j < i; ++j) {
                result += this.pairEnergy(objects.get(i), objects.get(j), links);
            }
        }
        for (i = 1; i < links.size(); ++i) {
            for (j = 0; j < i; ++j) {
                result += this.pairEnergy(links.get(i), links.get(j));
            }
        }
        return result;
    }

    @Override
    public double pairEnergy(Object3D obj1, Object3D obj2, LinkSet links) {
        for (int i = 0; i < this.forceFieldPairElementCount(); ++i) {
            ForceFieldPairElement ff = this.getForceFieldPairElement(i);
            if (!ff.handles(obj1, obj2, links)) continue;
            return ff.pairEnergy(obj1, obj2, links);
        }
        return 0.0;
    }

    @Override
    public double pairEnergy(Link l1, Link l2) {
        for (int i = 0; i < this.forceFieldLinkPairElementCount(); ++i) {
            ForceFieldLinkPairElement ff = this.getForceFieldLinkPairElement(i);
            if (!ff.handles(l1, l2)) continue;
            return ff.pairEnergy(l1, l2);
        }
        return 0.0;
    }

    @Override
    public boolean handles(Object3D obj1, Object3D obj2, LinkSet links) {
        for (int i = 0; i < this.forceFieldPairElementCount(); ++i) {
            ForceFieldPairElement ff = this.getForceFieldPairElement(i);
            if (!ff.handles(obj1, obj2, links)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handles(Link l1, Link l2) {
        for (int i = 0; i < this.forceFieldLinkPairElementCount(); ++i) {
            ForceFieldLinkPairElement ff = this.getForceFieldLinkPairElement(i);
            if (!ff.handles(l1, l2)) continue;
            return true;
        }
        return false;
    }
}

