/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph;

import javax.media.opengl.GL;
import viewer.graph.RenderableGraph;
import viewer.graph.RenderableGraphImp;

public class RendererSwitchGraph
extends RenderableGraphImp {
    private Logic logic;

    public RendererSwitchGraph(Logic logic) {
        this.logic = logic;
    }

    public Logic getLogic() {
        return this.logic;
    }

    @Override
    public void render(GL gl) {
        long bitset = this.logic.doLogic();
        for (int i = 0; i < this.size() && i < this.logic.maxFields(); ++i) {
            if ((bitset & (long)(1 << i)) != (long)(1 << i)) continue;
            this.getChild(i).render(gl);
        }
    }

    @Override
    public void addChild(RenderableGraph graph) {
        if (this.size() + 1 < this.logic.maxFields()) {
            super.addChild(graph);
        }
    }

    @Override
    public void insertChild(RenderableGraph graph, int index) {
        if (this.size() + 1 < this.logic.maxFields()) {
            super.insertChild(graph, index);
        }
    }

    public static interface Logic {
        public long doLogic();

        public int maxFields();
    }
}

