/*
 * Decompiled with CFR 0.152.
 */
package viewer.graph.rna;

import tools3d.objects3d.Object3D;
import viewer.graph.Object3DRenderableGraph;
import viewer.graph.RenderableGraph;
import viewer.graph.RenderableGraphController;
import viewer.graph.RendererBinarySwitchGraph;
import viewer.graphics.CloneableRenderableModel;
import viewer.rnadesign.AvailableRenderers;

public class RnaRendererGraphController
extends RenderableGraphController
implements CloneableRenderableModel {
    private boolean renderLinks = true;
    private boolean renderNucleotides = true;
    private boolean renderAtoms = true;
    private boolean renderStrands = true;
    private boolean renderBranchDescriptors = true;
    private AvailableRenderers renderer;

    public boolean isRenderAtoms() {
        return this.renderAtoms;
    }

    public boolean isRenderBranchDescriptors() {
        return this.renderBranchDescriptors;
    }

    public void setRenderBranchDescriptors(boolean b) {
        this.renderBranchDescriptors = b;
    }

    public void setRenderAtoms(boolean renderAtoms) {
        this.renderAtoms = renderAtoms;
    }

    public boolean isRenderLinks() {
        return this.renderLinks;
    }

    public void setRenderLinks(boolean renderLinks) {
        this.renderLinks = renderLinks;
    }

    public boolean isRenderNucleotides() {
        return this.renderNucleotides;
    }

    public void setRenderNucleotides(boolean renderNucleotides) {
        this.renderNucleotides = renderNucleotides;
    }

    public boolean isRenderStrands() {
        return this.renderStrands;
    }

    public void setRenderStrands(boolean renderStrands) {
        this.renderStrands = renderStrands;
    }

    public Object3DRenderableGraph getGraph(Object3D object) {
        return this.getGraph(object, this.getRoot());
    }

    private Object3DRenderableGraph getGraph(Object3D object, RenderableGraph graph) {
        if (graph instanceof Object3DRenderableGraph && ((Object3DRenderableGraph)graph).getObject().equals(object)) {
            return (Object3DRenderableGraph)graph;
        }
        for (int i = 0; i < graph.size(); ++i) {
            Object3DRenderableGraph g = this.getGraph(object, graph.getChild(i));
            if (g == null) continue;
            return g;
        }
        return null;
    }

    @Override
    public Object clone() {
        try {
            RnaRendererGraphController controller = (RnaRendererGraphController)super.clone();
            controller.setRoot((RenderableGraph)this.getRoot().clone());
            controller.loadState(this);
            return controller;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public AvailableRenderers getRenderer() {
        return this.renderer;
    }

    public void setRenderer(AvailableRenderers renderer) {
        this.renderer = renderer;
    }

    public void loadState(RnaRendererGraphController rc) {
        this.setWireframeMode(rc.isWireframeMode());
        this.setRefinementLevel(rc.getRefinementLevel());
        this.setMeshCached(rc.isMeshCached());
        this.setColorModel(rc.getColorModel());
        this.setRenderAtoms(rc.isRenderAtoms());
        this.setRenderNucleotides(rc.isRenderNucleotides());
        this.setRenderStrands(rc.isRenderStrands());
        this.setRenderLinks(rc.isRenderLinks());
        this.setRenderBranchDescriptors(rc.isRenderBranchDescriptors());
    }

    public void update() {
        this.update(this.getRoot());
    }

    private void update(RenderableGraph graph) {
        graph.update();
        for (int i = 0; i < graph.size(); ++i) {
            this.update(graph.getChild(i));
        }
    }

    class LinkPredicate
    implements RendererBinarySwitchGraph.Predicate {
        LinkPredicate() {
        }

        @Override
        public boolean isTrue() {
            return RnaRendererGraphController.this.isRenderLinks();
        }
    }

    class BranchDescriptorPredicate
    implements RendererBinarySwitchGraph.Predicate {
        BranchDescriptorPredicate() {
        }

        @Override
        public boolean isTrue() {
            return RnaRendererGraphController.this.isRenderBranchDescriptors();
        }
    }

    class AtomPredicate
    implements RendererBinarySwitchGraph.Predicate {
        AtomPredicate() {
        }

        @Override
        public boolean isTrue() {
            return RnaRendererGraphController.this.isRenderAtoms();
        }
    }

    class NucleotidePredicate
    implements RendererBinarySwitchGraph.Predicate {
        NucleotidePredicate() {
        }

        @Override
        public boolean isTrue() {
            return RnaRendererGraphController.this.isRenderNucleotides();
        }
    }

    class StrandPredicate
    implements RendererBinarySwitchGraph.Predicate {
        StrandPredicate() {
        }

        @Override
        public boolean isTrue() {
            return RnaRendererGraphController.this.isRenderStrands();
        }
    }
}

