/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.awt.Color;
import java.util.Random;
import viewer.graphics.ColorVector;

public class ColorPicker {
    private double red;
    private double green;
    private double blue;
    private double redFactor;
    private double blueFactor;
    private double greenFactor;

    public ColorPicker(Color color) {
        this((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
    }

    public ColorPicker(int red, int green, int blue) {
        this((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0);
    }

    public ColorPicker(double red, double green, double blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        Random r = new Random();
        this.redFactor = (double)(r.nextInt(20) - 10) / 255.0;
        this.blueFactor = (double)(r.nextInt(20) - 10) / 255.0;
        this.greenFactor = (double)(r.nextInt(20) - 10) / 255.0;
    }

    public Color getColor() {
        return new Color((int)(this.red * 255.0), (int)(this.green * 255.0), (int)(this.blue * 255.0));
    }

    public ColorVector getColorVector() {
        return new ColorVector(this.red, this.green, this.blue, 1.0);
    }

    public double getRed() {
        return this.red;
    }

    public double getBlue() {
        return this.blue;
    }

    public double getGreen() {
        return this.green;
    }

    public ColorVector getColorVector(int i) {
        double r = (this.red + (double)i * this.redFactor) % 2.0;
        double g = (this.green + (double)i * this.greenFactor) % 2.0;
        double b = (this.blue + (double)i * this.blueFactor) % 2.0;
        r = this.clampColor(r);
        g = this.clampColor(g);
        b = this.clampColor(b);
        return new ColorVector(r, g, b, 1.0);
    }

    private double clampColor(double d) {
        if (d < 0.0) {
            if (d >= -1.0) {
                return Math.abs(d);
            }
            return 2.0 - Math.abs(d);
        }
        if (d <= 1.0) {
            return d;
        }
        return 2.0 - d;
    }

    public Color getColor(int i) {
        ColorVector vector = this.getColorVector(i);
        return new Color((int)(vector.getRed() * 255.0), (int)(vector.getGreen() * 255.0), (int)(vector.getBlue() * 255.0));
    }
}

