/*
 * Decompiled with CFR 0.152.
 */
package viewer.graphics;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import tools3d.Vector4D;
import viewer.graphics.OldMesh;
import viewer.util.Tools;

public class Sphere
implements OldMesh {
    private double scale;
    private int crossSectionsX;
    private int crossSectionsY;
    private Color solidColor = Color.red;
    private Color wireframeColor = Color.blue;
    private OldMesh.Line[] lines;
    private OldMesh.Quad[] quads;
    private boolean renderWireFrame = false;
    private boolean renderSolid = true;

    public Sphere(double scale, int crossSectionsX, int crossSectionsY) {
        this.scale = scale;
        this.crossSectionsX = crossSectionsX;
        this.crossSectionsY = crossSectionsY;
    }

    @Override
    public void refine() {
        this.crossSectionsX *= 2;
        this.crossSectionsY *= 2;
        this.quads = null;
        this.lines = null;
    }

    public void setSolidColor(Color solidColor) {
        this.solidColor = solidColor;
    }

    public void setWireframeColor(Color wireframeColor) {
        this.wireframeColor = wireframeColor;
    }

    public boolean renderWireFrame() {
        return this.renderWireFrame;
    }

    public void renderWireFrame(boolean renderWireFrame) {
        this.renderWireFrame = renderWireFrame;
    }

    @Override
    public boolean renderSolid() {
        return this.renderSolid;
    }

    public void renderSolid(boolean renderSolid) {
        this.renderSolid = renderSolid;
    }

    @Override
    public OldMesh.Line[] getLines() {
        if (this.lines != null) {
            return this.lines;
        }
        ArrayList<OldMesh.Line> lines = new ArrayList<OldMesh.Line>();
        this.compute(null, lines);
        OldMesh.Line[] l = new OldMesh.Line[lines.size()];
        lines.toArray(l);
        this.lines = l;
        return l;
    }

    @Override
    public OldMesh.Quad[] getQuads() {
        if (this.quads != null) {
            return this.quads;
        }
        ArrayList<OldMesh.Quad> quads = new ArrayList<OldMesh.Quad>();
        this.compute(quads, null);
        OldMesh.Quad[] q = new OldMesh.Quad[quads.size()];
        quads.toArray(q);
        this.quads = q;
        return q;
    }

    @Override
    public Color getSolidColor() {
        return this.solidColor;
    }

    @Override
    public Color getWireframeColor() {
        return this.wireframeColor;
    }

    @Override
    public boolean renderWireframe() {
        return this.renderWireFrame;
    }

    private void compute(List<OldMesh.Quad> quads, List<OldMesh.Line> lines) {
        Vector4D v = new Vector4D(0.0, -this.scale, 0.0, 0.0);
        Vector4D vN = new Vector4D(0.0, 0.0, -1.0, 0.0);
        Vector4D y = new Vector4D(0.0, -1.0, 0.0, 0.0);
        double thetaIncrement = Math.PI * 2 / (double)this.crossSectionsX;
        double phiIncrement = Math.PI / (double)this.crossSectionsY;
        int thetaIncrementCount = 0;
        for (int phiIncrementCount = 0; phiIncrementCount < this.crossSectionsY; ++phiIncrementCount) {
            while (thetaIncrementCount < this.crossSectionsX) {
                Vector4D v1 = v;
                Vector4D v1N = new Vector4D(v1);
                v1N.normalize();
                Vector4D vX = v.cross(vN);
                vX.normalize();
                v = Tools.rotate(v, vX, phiIncrement);
                vN = Tools.rotate(vN, vX, phiIncrement);
                Vector4D v2 = v;
                Vector4D v2N = new Vector4D(v2);
                v2N.normalize();
                v = Tools.rotate(v, y, thetaIncrement);
                vN = Tools.rotate(vN, y, thetaIncrement);
                Vector4D v3 = v;
                Vector4D v3N = new Vector4D(v3);
                v3N.normalize();
                vX = v.cross(vN);
                vX.normalize();
                v = Tools.rotate(v, vX, -phiIncrement);
                vN = Tools.rotate(vN, vX, -phiIncrement);
                Vector4D v4 = v;
                Vector4D v4N = new Vector4D(v4);
                v4N.normalize();
                if (quads != null) {
                    OldMesh.Quad q = new OldMesh.Quad();
                    q.v1 = v1;
                    q.v2 = v2;
                    q.v3 = v3;
                    q.v4 = v4;
                    q.v1n = v1N;
                    q.v2n = v2N;
                    q.v3n = v3N;
                    q.v4n = v4N;
                    quads.add(q);
                }
                if (lines != null) {
                    OldMesh.Line l = new OldMesh.Line();
                    l.v1 = v1;
                    l.v2 = v2;
                    lines.add(l);
                    l = new OldMesh.Line();
                    l.v1 = v2;
                    l.v2 = v3;
                    lines.add(l);
                    l = new OldMesh.Line();
                    l.v1 = v3;
                    l.v2 = v4;
                    lines.add(l);
                    l = new OldMesh.Line();
                    l.v1 = v4;
                    l.v2 = v1;
                    lines.add(l);
                }
                ++thetaIncrementCount;
            }
            Vector4D vX = v.cross(vN);
            vX.normalize();
            v = Tools.rotate(v, vX, phiIncrement);
            vN = Tools.rotate(vN, vX, phiIncrement);
            thetaIncrementCount = 0;
        }
    }
}

