/*
 * Decompiled with CFR 0.152.
 */
package viewer.view;

import tools3d.Vector4D;
import viewer.event.ViewListener;
import viewer.event.ViewListenerManager;
import viewer.view.OrthogonalView;

public abstract class AbstractOrthogonalView
implements OrthogonalView {
    protected Vector4D viewDirection;
    protected Vector4D viewLocation;
    protected Vector4D viewDirectionNormal;
    private Vector4D viewDirectionCopy;
    private Vector4D viewLocationCopy;
    private Vector4D viewDirectionNormalCopy;
    protected double zoom = 1.0;
    private ViewListenerManager manager = new ViewListenerManager();
    private int zoomFactor = 1;

    public AbstractOrthogonalView(Vector4D viewDirection, Vector4D viewLocation, Vector4D viewDirectionNormal) {
        this.viewDirection = viewDirection;
        this.viewLocation = viewLocation;
        this.viewDirectionNormal = viewDirectionNormal;
        this.viewDirectionCopy = new Vector4D(viewDirection);
        this.viewLocationCopy = new Vector4D(viewLocation);
        this.viewDirectionNormalCopy = new Vector4D(viewDirectionNormal);
    }

    @Override
    public void reset() {
        this.viewDirection = new Vector4D(this.viewDirectionCopy);
        this.viewLocation = new Vector4D(this.viewLocationCopy);
        this.viewDirectionNormal = new Vector4D(this.viewDirectionNormalCopy);
        this.zoom = 1.0;
    }

    protected ViewListenerManager getManager() {
        return this.manager;
    }

    @Override
    public void addViewListener(ViewListener l) {
        this.manager.addViewListener(l);
    }

    public void removeViewListener(ViewListener l) {
        this.manager.removeViewListener(l);
    }

    @Override
    public Vector4D getViewDirection() {
        return this.viewDirection;
    }

    @Override
    public Vector4D getViewLocation() {
        return this.viewLocation;
    }

    @Override
    public Vector4D getViewDirectionNormal() {
        return this.viewDirectionNormal;
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    @Override
    public void zoomWorldView(double z) {
        z *= -1.0;
        double oldZoom = this.zoom;
        if (z > 0.0) {
            this.zoom *= 1.1;
            this.manager.notifyViewZoom(false, oldZoom, this.zoom);
        } else {
            this.zoom *= 0.9;
            this.manager.notifyViewZoom(false, oldZoom, this.zoom);
        }
    }

    @Override
    public void setViewDirection(double x, double y, double z) {
        this.viewDirection = new Vector4D(x, y, z, 0.0);
        this.manager.notifyViewChanged();
    }

    @Override
    public void setViewLocation(double x, double y, double z) {
        this.viewLocation = new Vector4D(x, y, z, 1.0);
        this.manager.notifyViewChanged();
    }

    @Override
    public void setViewNormal(double x, double y, double z) {
        this.viewDirectionNormal = new Vector4D(x, y, z, 0.0);
        this.manager.notifyViewChanged();
    }

    @Override
    public void setZoom(double zoom) {
        this.zoom = zoom;
        this.manager.notifyViewChanged();
    }
}

