/*
 * Decompiled with CFR 0.152.
 */
package viewer.view;

import tools3d.Vector4D;
import viewer.view.AbstractOrthogonalView;

public class XZView
extends AbstractOrthogonalView {
    private int scalar = 1;

    public XZView() {
        super(new Vector4D(0.0, -1.0, 0.0, 0.0), new Vector4D(0.0, 1.0, 0.0, 1.0), new Vector4D(0.0, 0.0, -1.0, 0.0));
    }

    @Override
    public void lookAt(double x, double y, double z) {
        Vector4D oldLocation = new Vector4D(this.viewLocation);
        this.viewLocation.setX(x);
        this.viewLocation.setZ(z);
        this.getManager().notifyViewTranslation(false, oldLocation, this.viewLocation);
    }

    @Override
    public void flipView() {
        this.viewDirection.setY(this.viewDirection.getY() * -1.0);
        this.viewLocation.setY(this.viewLocation.getY() * -1.0);
        this.scalar *= -1;
    }

    @Override
    public void translateWorldView(double x, double y) {
        Vector4D translation = new Vector4D((double)(-1 * this.scalar) * x, 0.0, (double)(-1 * this.scalar) * y, 0.0);
        Vector4D oldLocation = new Vector4D(this.viewLocation);
        this.viewLocation.add(translation);
        this.getManager().notifyViewTranslation(false, oldLocation, this.viewLocation);
    }
}

