package numerictools;

public class SimpleOptimizationNDResult implements OptimizationNDResult {

    double[] bestPosition; // best position found

    double bestValue; // best optimization value

    double error; // local error estimate (what delta was used to terminate loop ? )

    int stepCount; // number of steps needed to reach results

    /** initializes n-dimensional optimzation result */
    public SimpleOptimizationNDResult(int n) {
	bestPosition = new double[n];
    }


    public double[] getBestPosition() { return this.bestPosition; }

    public double getBestValue() { return this.bestValue; }

    public double getError() { return this.error; }

    public double getStepCount() { return this.stepCount; }

    public String toString() {
	String result =  "Best value: " + bestValue + " number iterations: " + stepCount + " values: ";
	for (int i = 0; i < bestPosition.length; ++i) {
	    result = result + " " + bestPosition[i];
	}
	return result;
    }

}
