/* Used to detect pseudoknots for radial placement algorithm. */
class Helix {
  int id;
  int[] ends = new int[2];
  int size = 0; // number of pairs
  int numCrossed = 0; // Number of external helices' basepair ends that this helix encapsulates.
  HashMap<Integer, Helix> crossedW = new HashMap<Integer, Helix>();
  
  Helix(int end1, int end2, int id) {
    ends[0] = end1;
    ends[1] = end2;
    this.id = id;
  }
  
  void setSize(int size) {
    this.size = size;
  }
}


/* Used for strand order function. */
class HelixEnd {
  int strandId;
  int relId; // Index relative to strand start
  int origId; // Index in ct file
  
  void setStrandId(int strandId) {
    this.strandId = strandId;
  }
  
  void setRelId(int relId) {
    this.relId = relId;
  }
  
  void setOrigId(int origId) {
    this.origId = origId;
  }
}

class Strand {
  int id;
  ArrayList<Integer> strandIds = new ArrayList<Integer>();
  int length;
  ArrayList<HelixEnd> helixEnds = new ArrayList<HelixEnd>();
  
  Strand(int id, int length) {
    this.id = id;
    strandIds.add(id);
    this.length = length;
  }
  
  void addEnd(HelixEnd _end) {
    helixEnds.add(_end);
  }
  
  void addId(int strandId) {
    strandIds.add(strandId);
  }
}

class InterHelix {
  HelixEnd end1 = new HelixEnd();
  HelixEnd end2 = new HelixEnd();
  
  InterHelix(int strand1, int relId1, int strand2, int relId2) {
    end1.setStrandId(strand1);
    end1.setRelId(relId1);
    end2.setStrandId(strand2);
    end2.setRelId(relId2);
  }
  
  InterHelix(int strand1, int relId1, int origId1, int strand2, int relId2, int origId2) {
    this(strand1, relId1, strand2, relId2);
    end1.setOrigId(origId1);
    end2.setOrigId(origId2);
  }
}